/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import java.time.OffsetDateTime;
import net.aholbrook.paseto.exception.claims.ExpiredTokenException;
import net.aholbrook.paseto.exception.claims.IssuedInFutureException;
import net.aholbrook.paseto.exception.claims.MissingClaimException;
import net.aholbrook.paseto.service.Token;
import net.aholbrook.paseto.service.TokenService;
import net.aholbrook.paseto.test.data.TestVector;
import net.aholbrook.paseto.test.utils.AssertUtils;
import org.junit.Assert;

public abstract class PasetoServiceTest {
    <_TokenType extends Token, _Footer> void encodeTestVector(TokenService<_TokenType> tokenService, TestVector<_TokenType, _Footer> tv) {
        Assert.assertNotNull((String)"paseto token service", tokenService);
        String encoded = tv.getFooter() != null ? tokenService.encode((Token)tv.getPayload(), tv.getFooter()) : tokenService.encode((Token)tv.getPayload());
        Assert.assertEquals((String)"Generated token does not match test vector.", (Object)tv.getToken(), (Object)encoded);
    }

    <_TokenType extends Token, _Footer> void encodeDecodeTestVector(TokenService<_TokenType> tokenService, TestVector<_TokenType, _Footer> tv) {
        Assert.assertNotNull((String)"paseto token service", tokenService);
        String encoded = tv.getFooter() != null ? tokenService.encode((Token)tv.getPayload(), tv.getFooter()) : tokenService.encode((Token)tv.getPayload());
        Token payload = tv.getFooter() != null ? tokenService.decode(encoded, tv.getFooter()) : tokenService.decode(encoded);
        Assert.assertEquals((String)"Decoded payload does not match test vector.", tv.getPayload(), (Object)payload);
    }

    <_TokenType extends Token, _Footer> void decodeTestVector(TokenService<_TokenType> tokenService, TestVector<_TokenType, _Footer> tv) {
        Assert.assertNotNull((String)"paseto token service", tokenService);
        Token payload = tv.getFooter() != null ? tokenService.decode(tv.getToken(), tv.getFooter()) : tokenService.decode(tv.getToken());
        Assert.assertEquals((String)"Decoded token does not match test vector.", tv.getPayload(), (Object)payload);
    }

    void checkWithoutExpiry(TokenService<Token> service) {
        Token token = new Token().setTokenId("id");
        AssertUtils.assertMissingClaimException(() -> service.encode(token), "TokenService", token, "EXPIRATION");
    }

    void checkExpired(TokenService<Token> service) {
        Token token = new Token().setTokenId("id");
        token.setIssuedAt(OffsetDateTime.now().minusMinutes(1L));
        token.setExpiration(OffsetDateTime.now().minusSeconds(1L));
        service.decode(service.encode(token));
    }

    void checkIssuedInFuture(TokenService<Token> service) {
        Token token = new Token().setTokenId("id");
        token.setIssuedAt(OffsetDateTime.now().plusMinutes(1L));
        token.setExpiration(OffsetDateTime.now().plusMinutes(5L));
        service.decode(service.encode(token));
    }

    void checkDefault(TokenService<Token> service) {
        try {
            this.checkWithoutExpiry(service);
            Assert.fail((String)"Failed to catch expected MissingClaimException.");
        }
        catch (MissingClaimException missingClaimException) {
            // empty catch block
        }
        try {
            this.checkExpired(service);
            Assert.fail((String)"Failed to catch expected ExpiredTokenException.");
        }
        catch (ExpiredTokenException expiredTokenException) {
            // empty catch block
        }
        try {
            this.checkIssuedInFuture(service);
            Assert.fail((String)"Failed to catch expected IssuedInFutureException.");
        }
        catch (IssuedInFutureException issuedInFutureException) {
            // empty catch block
        }
    }

    void checkOnlyCurrentlyValid(TokenService<Token> service) {
        try {
            this.checkWithoutExpiry(service);
            Assert.fail((String)"Failed to catch expected MissingClaimException.");
        }
        catch (MissingClaimException missingClaimException) {
            // empty catch block
        }
        try {
            this.checkExpired(service);
            Assert.fail((String)"Failed to catch expected ExpiredTokenException.");
        }
        catch (ExpiredTokenException expiredTokenException) {
            // empty catch block
        }
        this.checkIssuedInFuture(service);
    }

    void checkDefaultWithValidity(TokenService<Token> service) {
        this.checkWithoutExpiry(service);
        try {
            this.checkExpired(service);
            Assert.fail((String)"Failed to catch expected ExpiredTokenException.");
        }
        catch (ExpiredTokenException expiredTokenException) {
            // empty catch block
        }
        try {
            this.checkIssuedInFuture(service);
            Assert.fail((String)"Failed to catch expected IssuedInFutureException.");
        }
        catch (IssuedInFutureException issuedInFutureException) {
            // empty catch block
        }
    }

    void checkOnlyCurrentlyVaildWithValidity(TokenService<Token> service) {
        this.checkWithoutExpiry(service);
        try {
            this.checkExpired(service);
            Assert.fail((String)"Failed to catch expected ExpiredTokenException.");
        }
        catch (ExpiredTokenException expiredTokenException) {
            // empty catch block
        }
        this.checkIssuedInFuture(service);
    }
}

