/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import net.aholbrook.paseto.crypto.KeyPair;
import net.aholbrook.paseto.crypto.exception.ByteArrayLengthException;
import net.aholbrook.paseto.crypto.exception.CryptoProviderException;
import net.aholbrook.paseto.crypto.v1.V1CryptoProvider;
import net.aholbrook.paseto.test.data.RfcTestVectors;
import net.aholbrook.paseto.test.utils.AssertUtils;
import net.aholbrook.paseto.test.utils.TestContext;
import net.aholbrook.paseto.util.Hex;
import net.aholbrook.paseto.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class V1CryptoProviderTest {
    private static final byte[] HKDF_SALT = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final byte[] RSA_FAKE_SIGNATURE = new byte[256];

    private V1CryptoProvider v1CryptoProvider() {
        return TestContext.builders().v1CryptoProvider();
    }

    @Test
    public void crypto_v1_randomBytes() {
        byte[] r1 = this.v1CryptoProvider().randomBytes(24);
        byte[] r2 = this.v1CryptoProvider().randomBytes(24);
        AssertUtils.assertNotEquals(r1, r2);
    }

    @Test
    public void crypto_v1_nonce() {
        Assert.assertNotNull((Object)this.v1CryptoProvider().getNonceGenerator());
        byte[] r1 = this.v1CryptoProvider().getNonceGenerator().generateNonce();
        byte[] r2 = this.v1CryptoProvider().getNonceGenerator().generateNonce();
        AssertUtils.assertNotEquals(r1, r2);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_hkdfExtractAndExpand_nullSalt() {
        this.v1CryptoProvider().hkdfExtractAndExpand(null, HmacSha384TestVectors.VECTOR_1_KEY, HmacSha384TestVectors.VECTOR_1_DATA);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_hkdfExtractAndExpand_shortSalt() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().hkdfExtractAndExpand(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, HmacSha384TestVectors.VECTOR_1_KEY, HmacSha384TestVectors.VECTOR_1_DATA), "salt", 15, 16, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_hkdfExtractAndExpand_longSalt() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().hkdfExtractAndExpand(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, HmacSha384TestVectors.VECTOR_1_KEY, HmacSha384TestVectors.VECTOR_1_DATA), "salt", 17, 16, true);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_hkdfExtractAndExpand_nullIkm() {
        this.v1CryptoProvider().hkdfExtractAndExpand(HKDF_SALT, null, HmacSha384TestVectors.VECTOR_1_DATA);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_hkdfExtractAndExpand_invalidIkm() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().hkdfExtractAndExpand(HKDF_SALT, new byte[0], HmacSha384TestVectors.VECTOR_1_DATA), "inputKeyingMaterial", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_hkdfExtractAndExpand_nullInfo() {
        this.v1CryptoProvider().hkdfExtractAndExpand(HKDF_SALT, HmacSha384TestVectors.VECTOR_1_KEY, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_hkdfExtractAndExpand_invalidInfo() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().hkdfExtractAndExpand(HKDF_SALT, HmacSha384TestVectors.VECTOR_1_KEY, new byte[0]), "info", 0, 1, false);
    }

    @Test
    public void crypto_v1_hmacSha384() {
        byte[] hmac = this.v1CryptoProvider().hmacSha384(HmacSha384TestVectors.VECTOR_1_DATA, HmacSha384TestVectors.VECTOR_1_KEY);
        AssertUtils.assertEquals(HmacSha384TestVectors.VECOTR_1_HMAC, hmac);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_hmacSha384_nullMessage() {
        this.v1CryptoProvider().hmacSha384(null, HmacSha384TestVectors.VECTOR_1_DATA);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_hmacSha384_emptyMessage() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().hmacSha384(new byte[0], HmacSha384TestVectors.VECTOR_1_DATA), "m", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_hmacSha384_nullKey() {
        this.v1CryptoProvider().hmacSha384(HmacSha384TestVectors.VECTOR_1_DATA, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_hmacSha384_emptyKey() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().hmacSha384(HmacSha384TestVectors.VECTOR_1_DATA, new byte[0]), "key", 0, 1, false);
    }

    @Test
    public void crypto_v1_aes256CtrEncrypt() {
        byte[] c = this.v1CryptoProvider().aes256CtrEncrypt(Aes256CtrTestVectors.PLAINTEXT, Aes256CtrTestVectors.KEY, Aes256CtrTestVectors.IV);
        AssertUtils.assertEquals(Aes256CtrTestVectors.CIPHERTEXT, c);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_aes256CtrEncrypt_nullMessage() {
        this.v1CryptoProvider().aes256CtrEncrypt(null, Aes256CtrTestVectors.KEY, Aes256CtrTestVectors.IV);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_aes256CtrEncrypt_invalidMessage() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().aes256CtrEncrypt(new byte[0], Aes256CtrTestVectors.KEY, Aes256CtrTestVectors.IV), "m", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_aes256CtrEncrypt_nullKey() {
        this.v1CryptoProvider().aes256CtrEncrypt(Aes256CtrTestVectors.PLAINTEXT, null, Aes256CtrTestVectors.IV);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_aes256CtrEncrypt_invalidKey() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().aes256CtrEncrypt(Aes256CtrTestVectors.PLAINTEXT, new byte[0], Aes256CtrTestVectors.IV), "key", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_aes256CtrEncrypt_nullIv() {
        this.v1CryptoProvider().aes256CtrEncrypt(Aes256CtrTestVectors.PLAINTEXT, Aes256CtrTestVectors.KEY, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_aes256CtrEncrypt_invalidIv() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().aes256CtrEncrypt(Aes256CtrTestVectors.PLAINTEXT, Aes256CtrTestVectors.KEY, new byte[0]), "iv", 0, 8, false);
    }

    @Test
    public void crypto_v1_aes256CtrDecrypt() {
        byte[] m = this.v1CryptoProvider().aes256CtrDecrypt(Aes256CtrTestVectors.CIPHERTEXT, Aes256CtrTestVectors.KEY, Aes256CtrTestVectors.IV);
        AssertUtils.assertEquals(Aes256CtrTestVectors.PLAINTEXT, m);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_aes256CtrDecrypt_nullMessage() {
        this.v1CryptoProvider().aes256CtrDecrypt(null, Aes256CtrTestVectors.KEY, Aes256CtrTestVectors.IV);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_aes256CtrDecrypt_invalidMessage() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().aes256CtrDecrypt(new byte[0], Aes256CtrTestVectors.KEY, Aes256CtrTestVectors.IV), "c", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_aes256CtrDecrypt_nullKey() {
        this.v1CryptoProvider().aes256CtrDecrypt(Aes256CtrTestVectors.PLAINTEXT, null, Aes256CtrTestVectors.IV);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_aes256CtrDecrypt_invalidKey() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().aes256CtrDecrypt(Aes256CtrTestVectors.PLAINTEXT, new byte[0], Aes256CtrTestVectors.IV), "key", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_aes256CtrDecrypt_nullIv() {
        this.v1CryptoProvider().aes256CtrDecrypt(Aes256CtrTestVectors.PLAINTEXT, Aes256CtrTestVectors.KEY, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_aes256CtrDecrypt_invalidIv() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().aes256CtrDecrypt(Aes256CtrTestVectors.PLAINTEXT, Aes256CtrTestVectors.KEY, new byte[0]), "iv", 0, 8, false);
    }

    @Test(expected=CryptoProviderException.class)
    public void crypto_v1_rsaSign_badKey() {
        this.v1CryptoProvider().rsaSign(StringUtils.getBytesUtf8((String)"test"), new byte[]{1});
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_rsaSign_nullMessage() {
        this.v1CryptoProvider().rsaSign(null, RfcTestVectors.RFC_TEST_RSA_PRIVATE_KEY);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_rsaSign_invalidMessage() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().rsaSign(new byte[0], RfcTestVectors.RFC_TEST_RSA_PRIVATE_KEY), "m", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_rsaSign_nullPrivateKey() {
        this.v1CryptoProvider().rsaSign(StringUtils.getBytesUtf8((String)"test"), null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_rsaSign_invalidPrivateKey() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().rsaSign(StringUtils.getBytesUtf8((String)"test"), new byte[0]), "privateKey", 0, 1, false);
    }

    @Test(expected=CryptoProviderException.class)
    public void crypto_v1_rsaVerify_badKey() {
        this.v1CryptoProvider().rsaVerify(StringUtils.getBytesUtf8((String)"test"), RSA_FAKE_SIGNATURE, new byte[]{1});
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_rsaVerify_nullMessage() {
        this.v1CryptoProvider().rsaVerify(null, RSA_FAKE_SIGNATURE, RfcTestVectors.RFC_TEST_RSA_PRIVATE_KEY);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_rsaVerify_invalidMessage() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().rsaVerify(new byte[0], RSA_FAKE_SIGNATURE, RfcTestVectors.RFC_TEST_RSA_PRIVATE_KEY), "m", 0, 1, false);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_rsaVerify_nullSignature() {
        this.v1CryptoProvider().rsaVerify(StringUtils.getBytesUtf8((String)"test"), null, RfcTestVectors.RFC_TEST_RSA_PRIVATE_KEY);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_rsaVerify_shortSignature() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().rsaVerify(StringUtils.getBytesUtf8((String)"test"), new byte[255], RfcTestVectors.RFC_TEST_RSA_PRIVATE_KEY), "sig", 255, 256, true);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_rsaVerify_longSignature() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().rsaVerify(StringUtils.getBytesUtf8((String)"test"), new byte[257], RfcTestVectors.RFC_TEST_RSA_PRIVATE_KEY), "sig", 257, 256, true);
    }

    @Test(expected=NullPointerException.class)
    public void crypto_v1_rsaVerify_nullPublicKey() {
        this.v1CryptoProvider().rsaVerify(StringUtils.getBytesUtf8((String)"test"), RSA_FAKE_SIGNATURE, null);
    }

    @Test(expected=ByteArrayLengthException.class)
    public void crypto_v1_rsaVerify_invalidPublicKey() {
        AssertUtils.assertByteArrayLengthException(() -> this.v1CryptoProvider().rsaVerify(StringUtils.getBytesUtf8((String)"test"), RSA_FAKE_SIGNATURE, new byte[0]), "publicKey", 0, 1, false);
    }

    @Test
    public void crypto_v1_generateKeyPair() {
        byte[] message = StringUtils.getBytesUtf8((String)"test message");
        KeyPair keyPair = this.v1CryptoProvider().rsaGenerate();
        byte[] sig = this.v1CryptoProvider().rsaSign(message, keyPair.getSecretKey());
        this.v1CryptoProvider().rsaVerify(message, sig, keyPair.getPublicKey());
    }

    private static class Aes256CtrTestVectors {
        public static final byte[] KEY = Hex.decode((String)"603deb1015ca71be2b73aef0857d77811f352c073b6108d72d9810a30914dff4");
        public static final byte[] IV = Hex.decode((String)"f0f1f2f3f4f5f6f7f8f9fafbfcfdfeff");
        public static final byte[] PLAINTEXT = Hex.decode((String)"6bc1bee22e409f96e93d7e117393172a");
        public static final byte[] CIPHERTEXT = Hex.decode((String)"601ec313775789a5b7a7f504bbf3d228");

        private Aes256CtrTestVectors() {
        }
    }

    private static class HmacSha384TestVectors {
        public static final byte[] VECTOR_1_KEY = Hex.decode((String)"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
        public static final byte[] VECTOR_1_DATA = Hex.decode((String)"4869205468657265");
        public static final byte[] VECOTR_1_HMAC = Hex.decode((String)"afd03944d84895626b0825f4ab46907f15f9dadbe4101ec682aa034c7cebc59cfaea9ea9076ede7f4af152e8b2fa9cb6");

        private HmacSha384TestVectors() {
        }
    }
}

