/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import net.aholbrook.paseto.test.utils.AssertUtils;
import net.aholbrook.paseto.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void stringUtils_ntes() {
        Assert.assertEquals((Object)"", (Object)StringUtils.ntes(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.ntes((String)""));
        Assert.assertNotEquals((Object)"", (Object)StringUtils.ntes((String)"a"));
        Assert.assertNotEquals((Object)"", (Object)StringUtils.ntes((String)"testing"));
        Assert.assertNotEquals((Object)"", (Object)StringUtils.ntes((String)" "));
    }

    @Test
    public void stringUtils_notEmpty() {
        Assert.assertTrue((boolean)StringUtils.isEmpty(null));
        Assert.assertTrue((boolean)StringUtils.isEmpty((String)""));
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)"a"));
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)"testing"));
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)" "));
    }

    @Test
    public void stringUtils_getBytesUtf8() {
        AssertUtils.assertEquals(new byte[0], StringUtils.getBytesUtf8(null));
        AssertUtils.assertEquals(new byte[0], StringUtils.getBytesUtf8((String)""));
        AssertUtils.assertEquals(new byte[]{65}, StringUtils.getBytesUtf8((String)"A"));
        AssertUtils.assertEquals(new byte[]{116, 101, 115, 116}, StringUtils.getBytesUtf8((String)"test"));
        AssertUtils.assertEquals(new byte[]{-30, -103, -96}, StringUtils.getBytesUtf8((String)"\u2660"));
    }

    @Test
    public void stringUtils_fromUtf8Bytes() {
        Assert.assertEquals((Object)"", (Object)StringUtils.fromUtf8Bytes(null));
        Assert.assertEquals((Object)"", (Object)StringUtils.fromUtf8Bytes((byte[])new byte[0]));
        Assert.assertEquals((Object)"A", (Object)StringUtils.fromUtf8Bytes((byte[])new byte[]{65}));
        Assert.assertEquals((Object)"test", (Object)StringUtils.fromUtf8Bytes((byte[])new byte[]{116, 101, 115, 116}));
        Assert.assertEquals((Object)"\u2660", (Object)StringUtils.fromUtf8Bytes((byte[])new byte[]{-30, -103, -96}));
    }

    @Test
    public void stringUtils_isEqual() {
        Assert.assertTrue((boolean)StringUtils.isEqual((String)"", (String)""));
        Assert.assertTrue((boolean)StringUtils.isEqual(null, null));
        Assert.assertTrue((boolean)StringUtils.isEqual(null, (String)""));
        Assert.assertTrue((boolean)StringUtils.isEqual((String)"", null));
        Assert.assertTrue((boolean)StringUtils.isEqual((String)" ", (String)" "));
        Assert.assertTrue((boolean)StringUtils.isEqual((String)"A", (String)"A"));
        Assert.assertTrue((boolean)StringUtils.isEqual((String)"test", (String)"test"));
        Assert.assertTrue((boolean)StringUtils.isEqual((String)"\u2660", (String)"\u2660"));
        Assert.assertFalse((boolean)StringUtils.isEqual((String)"  ", (String)" "));
        Assert.assertFalse((boolean)StringUtils.isEqual((String)"AA", (String)"A"));
        Assert.assertFalse((boolean)StringUtils.isEqual((String)"testtest", (String)"test"));
        Assert.assertFalse((boolean)StringUtils.isEqual((String)"\u2660\u2660", (String)"\u2660"));
    }
}

