/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import net.aholbrook.paseto.Paseto;
import net.aholbrook.paseto.PasetoV2;
import net.aholbrook.paseto.TokenWithFooter;
import net.aholbrook.paseto.crypto.KeyPair;
import net.aholbrook.paseto.encoding.EncodingProvider;
import net.aholbrook.paseto.exception.DecryptionException;
import net.aholbrook.paseto.exception.InvalidFooterException;
import net.aholbrook.paseto.exception.InvalidHeaderException;
import net.aholbrook.paseto.exception.PasetoParseException;
import net.aholbrook.paseto.exception.PasetoStringException;
import net.aholbrook.paseto.exception.SignatureVerificationException;
import net.aholbrook.paseto.service.KeyId;
import net.aholbrook.paseto.service.Token;
import net.aholbrook.paseto.test.PasetoTest;
import net.aholbrook.paseto.test.data.CustomToken;
import net.aholbrook.paseto.test.data.RfcTestVectors;
import net.aholbrook.paseto.test.data.RfcToken;
import net.aholbrook.paseto.test.data.TestVector;
import net.aholbrook.paseto.test.data.TokenTestVectors;
import net.aholbrook.paseto.test.utils.AssertUtils;
import net.aholbrook.paseto.test.utils.TestContext;
import org.junit.Assert;
import org.junit.Test;

public class PasetoV2Test
extends PasetoTest {
    @Override
    protected Paseto createPaseto(byte[] nonce) {
        return TestContext.builders().pasetoBuilderV2(nonce).build();
    }

    private EncodingProvider encodingProvider() {
        return TestContext.builders().encodingProvider();
    }

    @Test
    public void v2_RfcVectorE1() {
        this.encryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_1);
    }

    @Test
    public void v2_RfcVectorE2() {
        this.encryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_2);
    }

    @Test
    public void v2_RfcVectorE3() {
        this.encryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_3);
    }

    @Test
    public void v2_RfcVectorE4() {
        this.encryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_4);
    }

    @Test
    public void v2_RfcVectorE5() {
        this.encryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_5);
    }

    @Test
    public void v2_RfcVectorE6() {
        this.encryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_6);
    }

    @Test
    public void v2_RfcVectorE1Decrypt() {
        this.decryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_1);
    }

    @Test
    public void v2_RfcVectorE2Decrypt() {
        this.decryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_2);
    }

    @Test
    public void v2_RfcVectorE3Decrypt() {
        this.decryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_3);
    }

    @Test
    public void v2_RfcVectorE4Decrypt() {
        this.decryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_4);
    }

    @Test
    public void v2_RfcVectorE5Decrypt() {
        this.decryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_5);
    }

    @Test
    public void v2_RfcVectorE6Decrypt() {
        this.decryptTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_E_6);
    }

    @Test
    public void v2_RfcVectorS1Sign() {
        this.signTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_S_1, true);
    }

    @Test
    public void v2_RfcVectorS2Sign() {
        this.signTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_S_2, true);
    }

    @Test
    public void v2_RfcVectorS1Verify() {
        this.verifyTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_S_1);
    }

    @Test
    public void v2_RfcVectorS2Verify() {
        this.verifyTestVector(RfcTestVectors.RFC_TEST_VECTOR_V2_S_2);
    }

    @Test
    public void v2_token1Local() {
        this.encryptTestVector(TokenTestVectors.TV_1_V2_LOCAL);
    }

    @Test
    public void v2_token1LocalWithFooter() {
        this.encryptTestVector(TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token2Local() {
        this.encryptTestVector(TokenTestVectors.TV_2_V2_LOCAL);
    }

    @Test
    public void v2_token2LocalWithFooter() {
        this.encryptTestVector(TokenTestVectors.TV_2_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token3Local() {
        this.encryptTestVector(TokenTestVectors.TV_3_V2_LOCAL);
    }

    @Test
    public void v2_token3LocalWithFooter() {
        this.encryptTestVector(TokenTestVectors.TV_3_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token4Local() {
        this.encryptTestVector(TokenTestVectors.TV_4_V2_LOCAL);
    }

    @Test
    public void v2_token4LocalWithFooter() {
        this.encryptTestVector(TokenTestVectors.TV_4_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token1LocalDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_1_V2_LOCAL);
    }

    @Test
    public void v2_token1LocalWithFooterDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token2LocalDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_2_V2_LOCAL);
    }

    @Test
    public void v2_token2LocalWithFooterDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_2_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token3LocalDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_3_V2_LOCAL);
    }

    @Test
    public void v2_token3LocalWithFooterDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_3_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token4LocalDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_4_V2_LOCAL);
    }

    @Test
    public void v2_token4LocalWithFooterDecrypt() {
        this.decryptTestVector(TokenTestVectors.TV_4_V2_LOCAL_WITH_FOOTER);
    }

    @Test
    public void v2_token1Public() {
        this.signTestVector(TokenTestVectors.TV_1_V2_PUBLIC, true);
    }

    @Test
    public void v2_token1PublicWithFooter() {
        this.signTestVector(TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER, true);
    }

    @Test
    public void v2_token2Public() {
        this.signTestVector(TokenTestVectors.TV_2_V2_PUBLIC, true);
    }

    @Test
    public void v2_token2PublicWithFooter() {
        this.signTestVector(TokenTestVectors.TV_2_V2_PUBLIC_WITH_FOOTER, true);
    }

    @Test
    public void v2_token3Public() {
        this.signTestVector(TokenTestVectors.TV_3_V2_PUBLIC, true);
    }

    @Test
    public void v2_token3PublicWithFooter() {
        this.signTestVector(TokenTestVectors.TV_3_V2_PUBLIC_WITH_FOOTER, true);
    }

    @Test
    public void v2_token4Public() {
        this.signTestVector(TokenTestVectors.TV_4_V2_PUBLIC, true);
    }

    @Test
    public void v2_token4PublicWithFooter() {
        this.signTestVector(TokenTestVectors.TV_4_V2_PUBLIC_WITH_FOOTER, true);
    }

    @Test
    public void v2_token1PublicVerify() {
        this.verifyTestVector(TokenTestVectors.TV_1_V2_PUBLIC);
    }

    @Test
    public void v2_token1PublicWithFooterVerify() {
        this.verifyTestVector(TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER);
    }

    @Test
    public void v2_token2PublicVerify() {
        this.verifyTestVector(TokenTestVectors.TV_2_V2_PUBLIC);
    }

    @Test
    public void v2_token2PublicWithFooterVerify() {
        this.verifyTestVector(TokenTestVectors.TV_2_V2_PUBLIC_WITH_FOOTER);
    }

    @Test
    public void v2_token3PublicVerify() {
        this.verifyTestVector(TokenTestVectors.TV_3_V2_PUBLIC);
    }

    @Test
    public void v2_token3PublicWithFooterVerify() {
        this.verifyTestVector(TokenTestVectors.TV_3_V2_PUBLIC_WITH_FOOTER);
    }

    @Test
    public void v2_token4PublicVerify() {
        this.verifyTestVector(TokenTestVectors.TV_4_V2_PUBLIC);
    }

    @Test
    public void v2_token4PublicWithFooterVerify() {
        this.verifyTestVector(TokenTestVectors.TV_4_V2_PUBLIC_WITH_FOOTER);
    }

    @Test
    public void v2_token1_extractFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(null);
        KeyId footer = (KeyId)paseto.extractFooter(tv.getToken(), KeyId.class);
        Assert.assertEquals((String)"extracted footer != footer", (Object)tv.getFooter(), (Object)footer);
    }

    @Test
    public void v2_token1_extractFooterString() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(null);
        String footerString = paseto.extractFooter(tv.getToken());
        KeyId footer = (KeyId)this.encodingProvider().decode(footerString, KeyId.class);
        Assert.assertEquals((String)"extracted footer != footer", (Object)tv.getFooter(), (Object)footer);
    }

    @Test
    public void v2_token1_extractMissingFooter() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_PUBLIC;
        Paseto paseto = this.createPaseto(null);
        KeyId footer = (KeyId)paseto.extractFooter(tv.getToken(), KeyId.class);
        Assert.assertNull((String)"footer not null", (Object)footer);
    }

    @Test
    public void v2_token1_localDecryptWithFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        TokenWithFooter result = paseto.decryptWithFooter(tv.getToken(), tv.getA(), tv.getPayloadClass(), KeyId.class);
        Assert.assertEquals((String)"extracted footer != footer", (Object)tv.getFooter(), (Object)result.getFooter());
    }

    @Test
    public void v2_token1_localDecryptWithFooterString() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        TokenWithFooter result = paseto.decryptWithFooter(tv.getToken(), tv.getA(), tv.getPayloadClass());
        KeyId footer = (KeyId)this.encodingProvider().decode((String)result.getFooter(), KeyId.class);
        Assert.assertEquals((String)"extracted footer != footer", (Object)tv.getFooter(), (Object)footer);
    }

    @Test
    public void v1_token1_publicVerifyWithFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        TokenWithFooter result = paseto.verifyWithFooter(tv.getToken(), tv.getB(), tv.getPayloadClass(), KeyId.class);
        Assert.assertEquals((String)"extracted footer != footer", (Object)tv.getFooter(), (Object)result.getFooter());
    }

    @Test
    public void v2_token1_publicVerifyWithFooterString() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        TokenWithFooter result = paseto.verifyWithFooter(tv.getToken(), tv.getB(), tv.getPayloadClass());
        KeyId footer = (KeyId)this.encodingProvider().decode((String)result.getFooter(), KeyId.class);
        Assert.assertEquals((String)"extracted footer != footer", (Object)tv.getFooter(), (Object)footer);
    }

    @Test(expected=DecryptionException.class)
    public void v2_token1_modifyPayload() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        String token = paseto.encrypt((Object)tv.getPayload(), tv.getA());
        token = this.modify(token, new int[]{20, 15, 20});
        paseto.decrypt(token, tv.getA(), tv.getPayloadClass());
    }

    @Test(expected=DecryptionException.class)
    public void v2_token1_modifyFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        String token = paseto.encrypt((Object)tv.getPayload(), tv.getA());
        token = this.modify(token, new int[]{token.length() - 1, token.length() - 4, token.length() - 6});
        paseto.decrypt(token, tv.getA(), tv.getPayloadClass());
    }

    @Test(expected=DecryptionException.class)
    public void v2_token1_decryptWrongKey() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        paseto.decrypt(tv.getToken(), RfcTestVectors.RFC_TEST_KEY, tv.getPayloadClass());
    }

    @Test(expected=SignatureVerificationException.class)
    public void v2_token1_verifyWrongKey() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_PUBLIC;
        Paseto paseto = this.createPaseto(tv.getB());
        paseto.verify(tv.getToken(), RfcTestVectors.RFC_TEST_PK, tv.getPayloadClass());
    }

    @Test(expected=InvalidHeaderException.class)
    public void v2_token1_v1LocalAsV2Local() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V1_LOCAL_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidHeaderException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt(tv.getToken(), tv.getA(), tv.getPayloadClass());
        }, "v1.local.", "v2.local.");
    }

    @Test(expected=InvalidHeaderException.class)
    public void v2_token1_v1LocalAsV2Public() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V1_LOCAL_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidHeaderException(() -> {
            Token cfr_ignored_0 = (Token)paseto.verify(tv.getToken(), tv.getA(), tv.getPayloadClass());
        }, "v1.local.", "v2.public.");
    }

    @Test(expected=InvalidHeaderException.class)
    public void v2_token1_v1PublicAsV2Local() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V1_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidHeaderException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt(tv.getToken(), tv.getA(), tv.getPayloadClass());
        }, "v1.public.", "v2.local.");
    }

    @Test(expected=InvalidHeaderException.class)
    public void v2_token1_v1PublicAsV2Public() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V1_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidHeaderException(() -> {
            Token cfr_ignored_0 = (Token)paseto.verify(tv.getToken(), tv.getA(), tv.getPayloadClass());
        }, "v1.public.", "v2.public.");
    }

    @Test(expected=InvalidHeaderException.class)
    public void v2_token1_publicAsLocal() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidHeaderException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt(tv.getToken(), tv.getA(), tv.getPayloadClass());
        }, "v2.public.", "v2.local.");
    }

    @Test(expected=InvalidHeaderException.class)
    public void v2_token1_localAsPublic() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidHeaderException(() -> {
            Token cfr_ignored_0 = (Token)paseto.verify(tv.getToken(), tv.getA(), tv.getPayloadClass());
        }, "v2.local.", "v2.public.");
    }

    @Test(expected=InvalidFooterException.class)
    public void v2_token1_localMissingFooter() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidFooterException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt(tv.getToken(), tv.getA(), "not-the-footer", tv.getPayloadClass());
        }, "", "not-the-footer");
    }

    @Test(expected=InvalidFooterException.class)
    public void v2_token1_publicMissingFooter() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_PUBLIC;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertInvalidFooterException(() -> {
            Token cfr_ignored_0 = (Token)paseto.verify(tv.getToken(), tv.getA(), "not-the-footer", tv.getPayloadClass());
        }, "", "not-the-footer");
    }

    @Test(expected=InvalidFooterException.class)
    public void v2_token1_localWrongFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        String given = this.encodingProvider().encode((Object)tv.getFooter());
        AssertUtils.assertInvalidFooterException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt(tv.getToken(), tv.getA(), "not-the-footer", tv.getPayloadClass());
        }, given, "not-the-footer");
    }

    @Test(expected=InvalidFooterException.class)
    public void v2_token1_publicWrongFooter() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(tv.getB());
        String given = this.encodingProvider().encode((Object)tv.getFooter());
        AssertUtils.assertInvalidFooterException(() -> {
            Token cfr_ignored_0 = (Token)paseto.verify(tv.getToken(), tv.getA(), "not-the-footer", tv.getPayloadClass());
        }, given, "not-the-footer");
    }

    @Test(expected=PasetoStringException.class)
    public void v2_badInput() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertPasetoStringException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt("junk", tv.getA(), tv.getPayloadClass());
        }, "junk");
    }

    @Test(expected=PasetoStringException.class)
    public void v2_badTokenDecrypt() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertPasetoStringException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt("v2.local.", tv.getA(), tv.getPayloadClass());
        }, "v2.local.");
    }

    @Test(expected=PasetoStringException.class)
    public void v2_badTokenVerify() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertPasetoStringException(() -> {
            Token cfr_ignored_0 = (Token)paseto.verify("v2.local.", tv.getA(), tv.getPayloadClass());
        }, "v2.local.");
    }

    @Test(expected=PasetoStringException.class)
    public void v2_shortTokenLocal() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_LOCAL;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertPasetoStringException(() -> {
            Token cfr_ignored_0 = (Token)paseto.decrypt("v2.local.c29tZXRoaW5n", tv.getA(), tv.getPayloadClass());
        }, "v2.local.c29tZXRoaW5n");
    }

    @Test(expected=PasetoStringException.class)
    public void v2_shortTokenPublic() {
        TestVector<Token, Void> tv = TokenTestVectors.TV_1_V2_PUBLIC;
        Paseto paseto = this.createPaseto(tv.getB());
        AssertUtils.assertPasetoStringException(() -> {
            Token cfr_ignored_0 = (Token)paseto.verify("v2.public.c29tZXRoaW5n", tv.getA(), tv.getPayloadClass());
        }, "v2.public.c29tZXRoaW5n");
    }

    @Test
    public void v2_token1_localNonce() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_LOCAL_WITH_FOOTER;
        Paseto paseto = this.createPaseto(null);
        String token1 = paseto.encrypt((Object)tv.getPayload(), tv.getA(), (Object)tv.getFooter());
        String token2 = paseto.encrypt((Object)tv.getPayload(), tv.getA(), (Object)tv.getFooter());
        Assert.assertNotEquals((String)"nonce failed, 2 tokens have same contents", (Object)token1, (Object)token2);
    }

    @Test
    public void v2_token1_publicNonce() {
        TestVector<Token, KeyId> tv = TokenTestVectors.TV_1_V2_PUBLIC_WITH_FOOTER;
        Paseto paseto = this.createPaseto(null);
        String token1 = paseto.encrypt((Object)tv.getPayload(), tv.getA(), (Object)tv.getFooter());
        String token2 = paseto.encrypt((Object)tv.getPayload(), tv.getA(), (Object)tv.getFooter());
        Assert.assertNotEquals((String)"nonce failed, 2 tokens have same contents", (Object)token1, (Object)token2);
    }

    @Test
    public void v2_token2_generateKeyPair() {
        Paseto paseto = this.createPaseto(null);
        KeyPair keyPair = paseto.generateKeyPair();
        String token = paseto.sign((Object)TokenTestVectors.TOKEN_2, keyPair.getSecretKey());
        CustomToken payload = (CustomToken)((Object)paseto.verify(token, keyPair.getPublicKey(), CustomToken.class));
        Assert.assertEquals((String)"decrypted payload != original payload", (Object)((Object)TokenTestVectors.TOKEN_2), (Object)((Object)payload));
    }

    @Test(expected=NullPointerException.class)
    public void v2_nullEncodingProvider() {
        new PasetoV2.Builder(null, TestContext.builders().v2CryptoProvider());
    }

    @Test(expected=NullPointerException.class)
    public void v2_nullCryptoProvider() {
        new PasetoV2.Builder(TestContext.builders().encodingProvider(), null);
    }

    @Test(expected=PasetoParseException.class)
    public void v2_local_parseException_missingSections() {
        Paseto paseto = this.createPaseto(null);
        AssertUtils.assertPasetoParseException(() -> {
            RfcToken cfr_ignored_0 = (RfcToken)((Object)((Object)paseto.decrypt("", RfcTestVectors.RFC_TEST_KEY, RfcToken.class)));
        }, "", PasetoParseException.Reason.MISSING_SECTIONS, 0);
    }

    @Test(expected=PasetoParseException.class)
    public void v2_public_parseException_missingSections() {
        Paseto paseto = this.createPaseto(null);
        AssertUtils.assertPasetoParseException(() -> {
            RfcToken cfr_ignored_0 = (RfcToken)((Object)((Object)paseto.verify("", RfcTestVectors.RFC_TEST_PK, RfcToken.class)));
        }, "", PasetoParseException.Reason.MISSING_SECTIONS, 0);
    }

    @Test(expected=PasetoParseException.class)
    public void v2_local_parseException_payloadLength() {
        Paseto paseto = this.createPaseto(null);
        AssertUtils.assertPasetoParseException(() -> {
            RfcToken cfr_ignored_0 = (RfcToken)((Object)((Object)paseto.decrypt("v2.local.aa", RfcTestVectors.RFC_TEST_KEY, RfcToken.class)));
        }, "v2.local.aa", PasetoParseException.Reason.PAYLOAD_LENGTH, 25);
    }

    @Test(expected=PasetoParseException.class)
    public void v2_public_parseException_payloadLength() {
        Paseto paseto = this.createPaseto(null);
        AssertUtils.assertPasetoParseException(() -> {
            RfcToken cfr_ignored_0 = (RfcToken)((Object)((Object)paseto.verify("v2.public.aa", RfcTestVectors.RFC_TEST_PK, RfcToken.class)));
        }, "v2.public.aa", PasetoParseException.Reason.PAYLOAD_LENGTH, 65);
    }
}

