/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import net.aholbrook.paseto.encoding.EncodingProvider;
import net.aholbrook.paseto.service.KeyId;
import net.aholbrook.paseto.test.data.KeyIdTestVectors;
import net.aholbrook.paseto.test.utils.TestContext;
import org.junit.Assert;
import org.junit.Test;

public class KeyIdTest {
    @Test
    public void keyId_encodeDecode1() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        String s = encodingProvider.encode((Object)KeyIdTestVectors.KEY_ID_1);
        KeyId keyId = (KeyId)encodingProvider.decode(s, KeyId.class);
        Assert.assertEquals((String)"decoded token", (Object)KeyIdTestVectors.KEY_ID_1, (Object)keyId);
    }

    @Test
    public void keyId_encodeDecode2() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        String s = encodingProvider.encode((Object)KeyIdTestVectors.KEY_ID_2);
        KeyId keyId = (KeyId)encodingProvider.decode(s, KeyId.class);
        Assert.assertEquals((String)"decoded token", (Object)KeyIdTestVectors.KEY_ID_2, (Object)keyId);
    }

    @Test
    public void keyId_encodeDecodeFooter() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        String s = encodingProvider.encode((Object)KeyIdTestVectors.KEY_ID_FOOTER);
        KeyIdTestVectors.Footer keyId = (KeyIdTestVectors.Footer)((Object)encodingProvider.decode(s, KeyIdTestVectors.Footer.class));
        Assert.assertEquals((String)"decoded token", (Object)((Object)KeyIdTestVectors.KEY_ID_FOOTER), (Object)((Object)keyId));
    }

    @Test
    public void keyId_decode1() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        KeyId keyId = (KeyId)encodingProvider.decode("{\"kid\":\"stored-in-the-footer\"}", KeyId.class);
        Assert.assertEquals((String)"decoded token", (Object)KeyIdTestVectors.KEY_ID_1, (Object)keyId);
    }

    @Test
    public void keyId_decode2() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        KeyId keyId = (KeyId)encodingProvider.decode("{\"kid\":\"UbkK8Y6iv4GZhFp6Tx3IWLWLfNXSEvJcdT3zdR65YZxo\"}", KeyId.class);
        Assert.assertEquals((String)"decoded token", (Object)KeyIdTestVectors.KEY_ID_2, (Object)keyId);
    }

    @Test
    public void keyId_decodeFooter() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        KeyIdTestVectors.Footer keyId = (KeyIdTestVectors.Footer)((Object)encodingProvider.decode("{\"field\":\"testing\",\"kid\":\"UbkK8Y6iv4GZhFp6Tx3IWLWLfNXSEvJcdT3zdR65YZxo\"}", KeyIdTestVectors.Footer.class));
        Assert.assertEquals((String)"decoded token", (Object)((Object)KeyIdTestVectors.KEY_ID_FOOTER), (Object)((Object)keyId));
    }

    @Test
    public void keyId_equals() {
        KeyId kid1 = new KeyId().setKeyId("1");
        KeyId kid2 = new KeyId().setKeyId("1");
        Assert.assertEquals((Object)kid1, (Object)kid1);
        Assert.assertEquals((Object)kid1, (Object)kid2);
        Assert.assertEquals((long)kid1.hashCode(), (long)kid2.hashCode());
    }

    @Test
    public void keyId_notEquals() {
        KeyId kid1 = new KeyId().setKeyId("1");
        KeyId kid2 = new KeyId().setKeyId("2");
        Assert.assertNotEquals((Object)kid1, (Object)new Object());
        Assert.assertEquals((Object)false, (Object)kid1.equals(null));
        Assert.assertEquals((Object)false, (Object)kid1.equals((Object)1));
        Assert.assertNotEquals((Object)kid1, (Object)kid2);
        Assert.assertNotEquals((long)kid1.hashCode(), (long)kid2.hashCode());
    }
}

