/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import java.time.OffsetDateTime;
import java.util.Objects;
import net.aholbrook.paseto.encoding.EncodingProvider;
import net.aholbrook.paseto.encoding.exception.EncodingException;
import net.aholbrook.paseto.service.Token;
import net.aholbrook.paseto.test.data.CustomToken;
import net.aholbrook.paseto.test.data.TokenTestVectors;
import net.aholbrook.paseto.test.utils.TestContext;
import org.junit.Assert;
import org.junit.Test;

public class EncodingTest {
    @Test
    public void token_encodeDecode1() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        String s = encodingProvider.encode((Object)TokenTestVectors.TOKEN_1);
        Token token2 = (Token)encodingProvider.decode(s, Token.class);
        Assert.assertEquals((String)"decoded token", (Object)TokenTestVectors.TOKEN_1, (Object)token2);
    }

    @Test
    public void token_decode1() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        Token token = (Token)encodingProvider.decode("{\"exp\":\"2039-01-01T00:00:00+00:00\",\"iss\":\"paragonie.com\",\"sub\":\"test\",\"aud\":\"pie-hosted.com\",\"jti\":\"87IFSGFgPNtQNNuw0AtuLttP\",\"nbf\":\"2038-04-01T00:00:00+00:00\",\"iat\":\"2038-03-17T00:00:00+00:00\"}", Token.class);
        Assert.assertEquals((String)"decoded token", (Object)TokenTestVectors.TOKEN_1, (Object)token);
    }

    @Test
    public void token_encodeDecode2() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        String s = encodingProvider.encode((Object)TokenTestVectors.TOKEN_2);
        CustomToken token2 = (CustomToken)((Object)encodingProvider.decode(s, CustomToken.class));
        Assert.assertEquals((String)"decoded token", (Object)((Object)TokenTestVectors.TOKEN_2), (Object)((Object)token2));
    }

    @Test
    public void token_decode2() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        CustomToken token = (CustomToken)((Object)encodingProvider.decode("{\"userId\":100,\"exp\":\"2018-01-01T17:23:44+00:00\",\"sub\":\"user-auth\",\"iss\":\"auth.example.com\",\"aud\":\"internal-service.example.com\",\"jti\":null,\"nbf\":\"2018-01-01T17:18:44+00:00\",\"iat\":\"2018-01-01T17:18:44+00:00\"}", CustomToken.class));
        Assert.assertEquals((String)"decoded token", (Object)((Object)TokenTestVectors.TOKEN_2), (Object)((Object)token));
    }

    @Test
    public void token_encodeDateTime() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        OffsetDateTime time = TokenTestVectors.TV_1_V1_LOCAL.getPayload().getExpiration();
        DateTimeTest test = new DateTimeTest();
        test.setExp(time);
        String s = encodingProvider.encode((Object)test);
        Assert.assertEquals((String)"encoded date time", (Object)"{\"exp\":\"2039-01-01T00:00:00+00:00\"}", (Object)s);
    }

    @Test
    public void token_decodeDateTime() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        OffsetDateTime time = TokenTestVectors.TV_1_V1_LOCAL.getPayload().getExpiration();
        DateTimeTest test = new DateTimeTest();
        test.setExp(time);
        DateTimeTest decoded = (DateTimeTest)encodingProvider.decode("{\"exp\":\"2039-01-01T00:00:00+00:00\"}", DateTimeTest.class);
        Assert.assertEquals((String)"decoded date time", (Object)test, (Object)decoded);
    }

    @Test
    public void token_encodeDateTimeNull() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        DateTimeTest test = new DateTimeTest();
        String s = encodingProvider.encode((Object)test);
        Assert.assertEquals((String)"encoded date time", (Object)"{}", (Object)s);
    }

    @Test
    public void token_decodeDateTimeNull() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        DateTimeTest test = new DateTimeTest();
        DateTimeTest decoded = (DateTimeTest)encodingProvider.decode("{\"exp\":null}", DateTimeTest.class);
        Assert.assertEquals((String)"decoded date time", (Object)test, (Object)decoded);
    }

    @Test
    public void token_decodeDateTimeMissing() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        DateTimeTest test = new DateTimeTest();
        DateTimeTest decoded = (DateTimeTest)encodingProvider.decode("{}", DateTimeTest.class);
        Assert.assertEquals((String)"decoded date time", (Object)test, (Object)decoded);
    }

    @Test
    public void token_encodeNull() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        String s = encodingProvider.encode(null);
        Assert.assertNull((Object)s);
    }

    @Test(expected=EncodingException.class)
    public void token_encodeError() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        encodingProvider.encode((Object)new BrokenType());
    }

    @Test
    public void token_decodeNull() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        Token token = (Token)encodingProvider.decode(null, Token.class);
        Assert.assertNull((Object)token);
    }

    @Test(expected=EncodingException.class)
    public void token_decodeEmpty() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        Token token = (Token)encodingProvider.decode("", Token.class);
    }

    @Test(expected=EncodingException.class)
    public void token_decodeError() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        Token token = (Token)encodingProvider.decode("notjson", Token.class);
    }

    @Test
    public void token_decodeDateTimeWrongType() {
        EncodingProvider encodingProvider = TestContext.builders().encodingProvider();
        DateTimeTest test = new DateTimeTest();
        DateTimeTest decoded = (DateTimeTest)encodingProvider.decode("{\"exp\":10000}", DateTimeTest.class);
        Assert.assertEquals((String)"decoded date time", (Object)test, (Object)decoded);
    }

    private static class BrokenType {
        private BrokenType() {
        }

        public String getName() {
            throw new NullPointerException();
        }
    }

    private static class DateTimeTest {
        private OffsetDateTime exp;

        private DateTimeTest() {
        }

        public OffsetDateTime getExp() {
            return this.exp;
        }

        public void setExp(OffsetDateTime exp) {
            this.exp = exp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateTimeTest that = (DateTimeTest)o;
            return Objects.equals(this.exp, that.exp);
        }

        public int hashCode() {
            return Objects.hash(this.exp);
        }
    }
}

