/*
 * Decompiled with CFR 0.152.
 */
package net.aholbrook.paseto.test;

import java.time.OffsetDateTime;
import java.util.Set;
import net.aholbrook.paseto.claims.Claim;
import net.aholbrook.paseto.claims.Claims;
import net.aholbrook.paseto.claims.CurrentlyValid;
import net.aholbrook.paseto.claims.ForAudience;
import net.aholbrook.paseto.claims.IssuedBy;
import net.aholbrook.paseto.claims.IssuedInPast;
import net.aholbrook.paseto.claims.VerificationContext;
import net.aholbrook.paseto.claims.WithSubject;
import net.aholbrook.paseto.exception.claims.ClaimException;
import net.aholbrook.paseto.exception.claims.ExpiredTokenException;
import net.aholbrook.paseto.exception.claims.IncorrectAudienceException;
import net.aholbrook.paseto.exception.claims.IncorrectIssuerException;
import net.aholbrook.paseto.exception.claims.IncorrectSubjectException;
import net.aholbrook.paseto.exception.claims.IssuedInFutureException;
import net.aholbrook.paseto.exception.claims.MissingClaimException;
import net.aholbrook.paseto.exception.claims.MultipleClaimException;
import net.aholbrook.paseto.exception.claims.NotYetValidTokenException;
import net.aholbrook.paseto.service.Token;
import net.aholbrook.paseto.test.data.CustomToken;
import net.aholbrook.paseto.test.data.TokenTestVectors;
import net.aholbrook.paseto.test.utils.AssertUtils;
import org.junit.Assert;
import org.junit.Test;

public class ClaimVerificationTest {
    private VerificationContext defaultVerification(Token token) {
        return Claims.verify((Token)token);
    }

    private VerificationContext standardVerification(Token token, OffsetDateTime time) {
        Claim[] claims = new Claim[]{new IssuedInPast(time, IssuedInPast.DEFAULT_ALLOWABLE_DRIFT), new CurrentlyValid(time, CurrentlyValid.DEFAULT_ALLOWABLE_DRIFT)};
        return Claims.verify((Token)token, (Claim[])claims);
    }

    @Test
    public void tokenVerification_default() {
        Token token = new Token().setIssuedAt(OffsetDateTime.now()).setExpiration(OffsetDateTime.now().plusSeconds(5L));
        this.defaultVerification(token);
    }

    @Test
    public void tokenVerification_valid() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getNotBefore().plusSeconds(5L);
        this.standardVerification(token, time);
    }

    @Test
    public void tokenVerification_valid_atExpiry() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getExpiration();
        this.standardVerification(token, time);
    }

    @Test(expected=ExpiredTokenException.class)
    public void tokenVerification_expired_afterExpiry() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getExpiration().plusDays(1L);
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test(expected=ExpiredTokenException.class)
    public void tokenVerification_expired_afterExpiry2() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getExpiration().plusSeconds(1L);
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test
    public void tokenVerification_expired_beforeExpiry() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getExpiration().minusSeconds(1L);
        this.standardVerification(token, time);
    }

    @Test(expected=MissingClaimException.class)
    public void tokenVerification_expired_missing() {
        Token token = TokenTestVectors.TOKEN_4;
        AssertUtils.assertMissingClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new CurrentlyValid()}), "CURRENTLY_VALID", token, "EXPIRATION");
    }

    @Test
    public void tokenVerification_expired_name() {
        Assert.assertEquals((String)"claim name", (Object)"CURRENTLY_VALID", (Object)new CurrentlyValid().name());
    }

    @Test(expected=NotYetValidTokenException.class)
    public void tokenVerification_issuedAt() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getIssuedAt();
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test(expected=NotYetValidTokenException.class)
    public void tokenVerification_issuedAt_afterIssued() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getIssuedAt().plusSeconds(1L);
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test(expected=NotYetValidTokenException.class)
    public void tokenVerification_issuedAt_afterIssued2() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getIssuedAt().plusSeconds(1L);
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test(expected=NotYetValidTokenException.class)
    public void tokenVerification_issuedAt_beforeIssuedGrace() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getIssuedAt().minusSeconds(1L);
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test(expected=MultipleClaimException.class)
    public void tokenVerification_issuedAt_beforeIssued() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getIssuedAt().minusSeconds(2L);
        AssertUtils.assertMultiClaimException(() -> this.standardVerification(token, time), new Class[]{IssuedInFutureException.class, NotYetValidTokenException.class});
    }

    @Test(expected=MissingClaimException.class)
    public void tokenVerification_issuedAt_missing() {
        Token token = TokenTestVectors.TOKEN_4;
        AssertUtils.assertMissingClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new IssuedInPast()}), "ISSUED_IN_PAST", token, "ISSUED_AT");
    }

    @Test
    public void tokenVerification_notBefore_atValid() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getNotBefore();
        this.standardVerification(token, time);
    }

    @Test
    public void tokenVerification_issuedAt_name() {
        Assert.assertEquals((String)"claim name", (Object)"ISSUED_IN_PAST", (Object)new IssuedInPast().name());
    }

    @Test
    public void tokenVerification_notBefore_afterValid() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getNotBefore().plusSeconds(1L);
        this.standardVerification(token, time);
    }

    @Test
    public void tokenVerification_notBefore_afterValid2() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getNotBefore().plusSeconds(1L);
        this.standardVerification(token, time);
    }

    @Test
    public void tokenVerification_notBefore_beforeValidGrace() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getNotBefore().minusSeconds(1L);
        this.standardVerification(token, time);
    }

    @Test(expected=NotYetValidTokenException.class)
    public void tokenVerification_notBefore_beforeValid() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getNotBefore().minusSeconds(2L);
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test(expected=NotYetValidTokenException.class)
    public void tokenVerification_notBefore_atIssued() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getIssuedAt();
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test(expected=NotYetValidTokenException.class)
    public void tokenVerification_notBefore_beforeIssued() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getIssuedAt().minusSeconds(1L);
        AssertUtils.assertClaimException(() -> this.standardVerification(token, time), null, "CURRENTLY_VALID", token);
    }

    @Test
    public void tokenVerification_issuer() {
        Token token = TokenTestVectors.TOKEN_1;
        String issuer = TokenTestVectors.TOKEN_1.getIssuer();
        Claims.verify((Token)token, (Claim[])new Claim[]{new IssuedBy(issuer)});
    }

    @Test(expected=IncorrectIssuerException.class)
    public void tokenVerification_issuer_mismatch() {
        Token token = TokenTestVectors.TOKEN_1;
        String issuer = TokenTestVectors.TOKEN_1.getSubject();
        AssertUtils.assertClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new IssuedBy(issuer)}), e -> {
            Assert.assertEquals((Object)issuer, (Object)((IncorrectIssuerException)e).getExpected());
            Assert.assertEquals((Object)token.getIssuer(), (Object)((IncorrectIssuerException)e).getIssuer());
        }, "ISSUED_BY", token);
    }

    @Test(expected=MissingClaimException.class)
    public void tokenVerification_issuer_missing() {
        Token token = TokenTestVectors.TOKEN_3;
        String issuer = TokenTestVectors.TOKEN_2.getIssuer();
        AssertUtils.assertMissingClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new IssuedBy(issuer)}), "ISSUED_BY", token, "ISSUER");
    }

    @Test
    public void tokenVerification_issuer_name() {
        Assert.assertEquals((String)"claim name", (Object)"ISSUED_BY", (Object)new IssuedBy(null).name());
    }

    @Test
    public void tokenVerification_audience() {
        Token token = TokenTestVectors.TOKEN_1;
        String audience = TokenTestVectors.TOKEN_1.getAudience();
        Claims.verify((Token)token, (Claim[])new Claim[]{new ForAudience(audience)});
    }

    @Test(expected=IncorrectAudienceException.class)
    public void tokenVerification_audience_mismatch() {
        Token token = TokenTestVectors.TOKEN_1;
        String audience = TokenTestVectors.TOKEN_1.getIssuer();
        AssertUtils.assertClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new ForAudience(audience)}), e -> {
            Assert.assertEquals((Object)audience, (Object)((IncorrectAudienceException)e).getExpected());
            Assert.assertEquals((Object)token.getAudience(), (Object)((IncorrectAudienceException)e).getAudience());
        }, "FOR_AUDIENCE", token);
    }

    @Test(expected=MissingClaimException.class)
    public void tokenVerification_audience_missing() {
        Token token = TokenTestVectors.TOKEN_3;
        String audience = TokenTestVectors.TOKEN_1.getAudience();
        AssertUtils.assertMissingClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new ForAudience(audience)}), "FOR_AUDIENCE", token, "AUDIENCE");
    }

    @Test
    public void tokenVerification_audience_name() {
        Assert.assertEquals((String)"claim name", (Object)"FOR_AUDIENCE", (Object)new ForAudience(null).name());
    }

    @Test
    public void tokenVerification_subject() {
        Token token = TokenTestVectors.TOKEN_1;
        String subject = TokenTestVectors.TOKEN_1.getSubject();
        Claims.verify((Token)token, (Claim[])new Claim[]{new WithSubject(subject)});
    }

    @Test(expected=IncorrectSubjectException.class)
    public void tokenVerification_subject_mismatch() {
        Token token = TokenTestVectors.TOKEN_1;
        String subject = TokenTestVectors.TOKEN_1.getAudience();
        AssertUtils.assertClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new WithSubject(subject)}), e -> {
            Assert.assertEquals((Object)subject, (Object)((IncorrectSubjectException)e).getExpected());
            Assert.assertEquals((Object)token.getSubject(), (Object)((IncorrectSubjectException)e).getSubject());
        }, "HAS_SUBJECT", token);
    }

    @Test(expected=MissingClaimException.class)
    public void tokenVerification_subject_missing() {
        Token token = TokenTestVectors.TOKEN_3;
        String subject = TokenTestVectors.TOKEN_1.getSubject();
        AssertUtils.assertMissingClaimException(() -> Claims.verify((Token)token, (Claim[])new Claim[]{new WithSubject(subject)}), "HAS_SUBJECT", token, "SUBJECT");
    }

    @Test
    public void tokenVerification_subject_name() {
        Assert.assertEquals((String)"claim name", (Object)"HAS_SUBJECT", (Object)new WithSubject(null).name());
    }

    @Test
    public void tokenVerificationContext() {
        Token token = TokenTestVectors.TOKEN_1;
        OffsetDateTime time = token.getNotBefore().plusSeconds(5L);
        VerificationContext context = this.standardVerification(token, time);
        Assert.assertTrue((boolean)context.hasClaim("ISSUED_IN_PAST"));
        Assert.assertTrue((boolean)context.hasClaim("CURRENTLY_VALID"));
        Set names = context.getVerifiedClaims();
        Assert.assertTrue((boolean)names.contains("ISSUED_IN_PAST"));
        Assert.assertTrue((boolean)names.contains("CURRENTLY_VALID"));
        Assert.assertEquals((Object)token, (Object)context.getToken());
        Assert.assertFalse((boolean)context.hasClaim(null));
        Assert.assertFalse((boolean)context.hasClaim(""));
    }

    @Test(expected=MultipleClaimException.class)
    public void multipleClaimException_message() {
        CustomToken token = TokenTestVectors.TOKEN_2;
        MultipleClaimException mce = new MultipleClaimException((Token)token);
        mce.add((ClaimException)new IncorrectAudienceException("correct", "wrong", "FOR_AUDIENCE", (Token)token));
        mce.add((ClaimException)new IncorrectIssuerException("correct", "wrong", "ISSUED_BY", (Token)token));
        String message = mce.getMessage();
        Assert.assertEquals((Object)"Multiple verification errors: FOR_AUDIENCE: Token audience is \"wrong\", required: \"correct\"\nISSUED_BY: Token issued by \"wrong\", required: \"correct\"", (Object)message);
        throw mce;
    }
}

