/*
 * Decompiled with CFR 0.152.
 */
package net.aethersanctum.lilrest.config;

import net.aethersanctum.lilrest.config.ConfigFactory;
import net.aethersanctum.lilrest.config.TestConfig;
import org.junit.Assert;
import org.junit.Test;

public class ConfigFactoryTest {
    @Test(expected=IllegalArgumentException.class)
    public void constructFailConfigNotFound() {
        System.setProperty("useConfig", "src/test/resources/nonexistent.properties");
        ConfigFactory factory = new ConfigFactory();
    }

    @Test
    public void constructUnspecifiedFromSystemProperties() {
        System.getProperties().remove("useConfig");
        System.setProperty("somekey", "bork");
        ConfigFactory factory = new ConfigFactory();
        TestConfig config = (TestConfig)factory.extract(TestConfig.class);
        String value = config.someKey();
        Assert.assertEquals((Object)"bork", (Object)value);
    }

    @Test
    public void constructFromFile() {
        System.setProperty("useConfig", "src/test/resources/test.properties");
        ConfigFactory factory = new ConfigFactory();
    }

    @Test
    public void constructFromClasspath() {
        System.setProperty("useConfig", "test.properties");
        ConfigFactory factory = new ConfigFactory();
    }

    @Test
    public void extraction() {
        System.setProperty("useConfig", "test.properties");
        ConfigFactory factory = new ConfigFactory();
        TestConfig config = (TestConfig)factory.extract(TestConfig.class);
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void retrieval() {
        System.setProperty("useConfig", "test.properties");
        ConfigFactory factory = new ConfigFactory();
        TestConfig config = (TestConfig)factory.extract(TestConfig.class);
        String value = config.someKey();
        Assert.assertEquals((Object)"somevalue", (Object)value);
    }
}

