/*
 * Decompiled with CFR 0.152.
 */
package net.aethersanctum.lilrest.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import net.aethersanctum.lilrest.config.ConfigException;
import org.skife.config.ConfigurationObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class ConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFactory.class);
    private final Properties configProperties = ConfigFactory.findConfigProperties();
    private final ConfigurationObjectFactory factory = new ConfigurationObjectFactory(this.configProperties);

    public <T> T extract(@Nonnull Class<T> configClass) {
        LOG.info("extracting {}", (Object)configClass.getCanonicalName());
        return (T)this.factory.build(configClass);
    }

    public ConfigFactory() {
        LOG.info("loaded {} config properties", (Object)this.configProperties.size());
    }

    private static Properties findConfigProperties() {
        String useConfig = System.getProperty("useConfig");
        if (useConfig != null) {
            return ConfigFactory.loadProperties(useConfig);
        }
        return System.getProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(String location) {
        try (InputStream inStream = ConfigFactory.propertiesStream(location);){
            Properties props = new Properties();
            props.load(inStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    private static InputStream propertiesStream(String location) throws FileNotFoundException {
        InputStream inStream;
        File confFile = new File(location);
        if (confFile.canRead()) {
            inStream = new FileInputStream(new File(location));
        } else {
            inStream = ConfigFactory.class.getClassLoader().getResourceAsStream(location);
            if (inStream == null) {
                throw new IllegalArgumentException("Couldn't find config file " + location + " in filesystem or classpath.");
            }
        }
        return inStream;
    }
}

