/*
 * Decompiled with CFR 0.152.
 */
package net.aethersanctum.lilrest.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.aethersanctum.lilrest.config.ConfigException;
import org.skife.config.ConfigurationObjectFactory;

public final class ConfigFactory {
    private final Properties configProperties = ConfigFactory.findConfigProperties();
    private final ConfigurationObjectFactory factory = new ConfigurationObjectFactory(this.configProperties);

    public <T> T extract(@Nonnull Class<T> configClass) {
        return (T)this.factory.build(configClass);
    }

    private static Properties findConfigProperties() {
        String useConfig = System.getProperty("useConfig");
        if (useConfig != null) {
            return ConfigFactory.loadProperties(useConfig);
        }
        return System.getProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(String location) {
        try (InputStream inStream = ConfigFactory.propertiesStream(location);){
            Properties props = new Properties();
            props.load(inStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    private static InputStream propertiesStream(String location) throws FileNotFoundException {
        File confFile = new File(location);
        InputStream inStream = confFile.canRead() ? new FileInputStream(new File(location)) : ConfigFactory.class.getClassLoader().getResourceAsStream(location);
        return inStream;
    }
}

