package net.aequologica.neo.serioulizer.jaxrs.testutils;

import java.io.IOException;
import java.security.Principal;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;

import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.mockito.Mockito;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import net.aequologica.neo.serioulizer.InMemoryReaderWriter;
import net.aequologica.neo.serioulizer.jaxrs.ObjectMapperProvider;

public class MockResourceConfig<T>  {
    
    public ResourceConfig create(final Class<?> componentClass, @SuppressWarnings("rawtypes") TypeLiteral typeLiteral) {
        ResourceConfig rc = new ResourceConfig();

        rc.register(componentClass);

        // mock user auth
        final SecurityContext securityContextMock = Mockito.mock(SecurityContext.class);
        Mockito.when(securityContextMock.getUserPrincipal()).thenReturn(new Principal() {
            @Override
            public String getName() {
                return "anonymous";
            }
        });
        rc.register(new ContainerRequestFilter() {
            @Override
            public void filter(final ContainerRequestContext containerRequestContext) throws IOException {
                containerRequestContext.setSecurityContext(securityContextMock);
            }
        });

        // jackson boilerplate
        rc.register(JacksonJsonProvider.class);
        rc.register(ObjectMapperProvider.class);
        
        // hk2 boilerplate
        rc.register(new AbstractBinder() {
            
            @SuppressWarnings("unchecked")
            @Override
            protected void configure() {
                bind(InMemoryReaderWriter.class).to(typeLiteral);
                bindAsContract(typeLiteral);
            }
        });
        
        return rc;
    }
    
}
