/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.serioulizer.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.aequologica.neo.serioulizer.Serioulizer;
import net.aequologica.neo.serioulizer.jackson.AbstractReaderWriter;

@Singleton
public class SeriousReaderWriter<T>
extends AbstractReaderWriter<T> {
    @Inject
    Serioulizer serioulizer;

    public SeriousReaderWriter(TypeReference<T> valueTypeRef) {
        super(valueTypeRef);
    }

    public SeriousReaderWriter(TypeReference<T> valueTypeRef, Serioulizer serioulizer) {
        super(valueTypeRef);
        this.serioulizer = serioulizer;
    }

    @Override
    public void write(Path path, T t) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        byte[] bytes = this.objectMapper.writeValueAsBytes(t);
        if (t == null) {
            this.serioulizer.delete(path);
        } else {
            this.serioulizer.write(path, Serioulizer.createStream(bytes, "application/json;charset=" + StandardCharsets.UTF_8.name()));
        }
    }

    @Override
    public T read(Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = this.serioulizer.getStream(path).getInputStream();){
            if (inputStream == null) {
                throw new FileNotFoundException(path.toString());
            }
            Object t = this.read(inputStream);
            return t;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

