/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.serioulizer.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import net.aequologica.neo.serioulizer.ReaderWriter;

public abstract class AbstractReaderWriter<T>
implements ReaderWriter<T> {
    protected final ObjectMapper objectMapper = AbstractReaderWriter.createMapper();
    protected final TypeReference<T> valueTypeRef;

    public AbstractReaderWriter(TypeReference<T> valueTypeRef) {
        this.valueTypeRef = valueTypeRef;
    }

    @Override
    public void write(OutputStream outputStream, T t) throws IOException {
        this.objectMapper.writeValue(outputStream, t);
    }

    @Override
    public void write(Writer writer, T t) throws IOException {
        this.objectMapper.writeValue(writer, t);
    }

    @Override
    public T read(InputStream inputStream) throws IOException {
        return (T)this.objectMapper.readValue(inputStream, this.valueTypeRef);
    }

    @Override
    public T read(Reader reader) throws IOException {
        return (T)this.objectMapper.readValue(reader, this.valueTypeRef);
    }

    public static ObjectMapper createMapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ret.registerModule((Module)new JavaTimeModule());
        return ret;
    }
}

