/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.serioulizer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;

public interface Serioulizer
extends Closeable {
    public List<Path> list(Path var1) throws IOException;

    public void write(Path var1, Stream var2) throws IOException;

    public Stream getStream(Path var1) throws IOException;

    public void delete(Path var1) throws IOException;

    @Override
    default public void close() throws IOException {
    }

    public static Stream createStream(InputStream inputStream, String mimeType, long length) {
        if (inputStream == null) {
            return null;
        }
        return new StreamImpl(inputStream, mimeType, length);
    }

    public static Stream createStream(byte[] bytes, String mimeType) {
        if (bytes == null) {
            return null;
        }
        return new StreamImpl(new ByteArrayInputStream(bytes), mimeType, bytes.length);
    }

    public static Stream createStream(String content) {
        if (content == null) {
            return null;
        }
        String charset = StandardCharsets.UTF_8.name();
        return Serioulizer.createStream((InputStream)new ReaderInputStream((Reader)new StringReader(content), charset), "text/plain; charset=" + charset, -1L);
    }

    public static String read(InputStream inputStream) throws IOException {
        String charset = StandardCharsets.UTF_8.name();
        return Serioulizer.read(inputStream, charset);
    }

    public static String read(InputStream inputStream, String charsetName) throws IOException {
        int length;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(charsetName);
    }

    public static interface Stream
    extends Closeable {
        public InputStream getInputStream();

        public String getMimeType();

        public long getLength();
    }

    public static class StreamImpl
    implements Stream {
        public final InputStream inputStream;
        public final String mimeType;
        public final long length;

        StreamImpl(InputStream inputStream, String mimeType, long length) {
            this.inputStream = inputStream;
            this.mimeType = mimeType != null ? mimeType : "text/plain;charset=" + StandardCharsets.UTF_8.name();
            this.length = length;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

