/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.serioulizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Alternative;
import net.aequologica.neo.serioulizer.ReaderWriter;

@Alternative
public class InMemoryReaderWriter<T>
implements ReaderWriter<T> {
    private final Map<Path, T> map;

    public InMemoryReaderWriter() {
        this(new HashMap());
    }

    public InMemoryReaderWriter(Map<Path, T> objectStore) {
        this.map = objectStore != null ? objectStore : new HashMap();
    }

    @Override
    public void write(OutputStream outputStream, T t) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(Writer writer, T t) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(Path path, T t) throws IOException {
        if (t == null) {
            this.map.remove(path);
        } else {
            this.map.put(path, t);
        }
    }

    @Override
    public T read(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T read(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T read(Path path) throws IOException {
        return this.map.get(path);
    }
}

