package net.aequologica.neo.serioulizer.jackson;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

import javax.inject.Inject;
import javax.inject.Singleton;

import com.fasterxml.jackson.core.type.TypeReference;
import net.aequologica.neo.serioulizer.Serioulizer;

@Singleton
public class SeriousReaderWriter<T> extends AbstractReaderWriter<T>  {

    @Inject
    Serioulizer serioulizer;

    public SeriousReaderWriter(TypeReference<T> valueTypeRef) {
        super(valueTypeRef);
    }

    public SeriousReaderWriter(TypeReference<T> valueTypeRef, Serioulizer serioulizer) {
        super(valueTypeRef);
        this.serioulizer = serioulizer;
    }

    @Override
    public void write(Path path, T t) throws IOException {
        if (path == null) {
            throw new NullPointerException("path"); 
        }
        final byte[] bytes = this.objectMapper.writeValueAsBytes(t); // "Encoding used will be UTF-8."
        if (t == null) {
            serioulizer.delete(path);
        } else {
            serioulizer.write(path, Serioulizer.createStream(bytes, "application/json;charset="+StandardCharsets.UTF_8.name()));
        }
    }

    @Override
    public T read(Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path"); 
        }
        try (final InputStream inputStream = serioulizer.getStream(path).getInputStream()) {
            if (inputStream == null) {
                throw new FileNotFoundException(path.toString());
            }
            T t = read(inputStream);
            return t;
        }
    }
}
