package net.aequologica.neo.serioulizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

import javax.enterprise.inject.Alternative;

@Alternative
public class InMemoryReaderWriter<T> implements ReaderWriter<T> {

    private final Map<Path, T> map;
    
    public InMemoryReaderWriter() {
        this(new HashMap<>());
    }

    public InMemoryReaderWriter(final Map<Path, T> objectStore) {
        this.map = objectStore != null ? objectStore : new HashMap<>();
    }

    @Override
    public void write(final OutputStream outputStream, final T t) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(final java.io.Writer writer, final T t) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(final Path path, final T t) throws IOException {
        if (t == null) {
            map.remove(path);
        } else {
            map.put(path, t);
        }
    }

    @Override
    public T read(final InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T read(final java.io.Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T read(final Path path) throws IOException {
        return map.get(path);
    }

}
