# <span style="float:left; margin-right:40px;">![U](../assets/images/alphabet/051-16th-Century-letter-u-q85-187x200.jpg "U")</span><span style="margin-left:-40px;">pdating this Application with Zero Downtime</span>

Basically, zero downtime update consists of 4 steps:

1. **upload** new application to HANA Cloud Platform.
1. **start** new application on a new VM.
1. **disable** old VM(s): every new request is served by the new VM; existing sessions continue normally on their old VM.
1. **stop** the old VM(s) when all old sessions are closed.

cf. [Updating Applications with Zero Downtime](https://help.hana.ondemand.com/help/frameset.htm?a10f6c2071b443698eb7dfc411d0ed6d.html) in [HANA Cloud Documentation](https://help.hana.ondemand.com);

## 1. prologue

### 1.1 make sure you have the latest neo sdk

<span style="display:none"><!-- understand geppaefact.js before changing anything--></span>

<span id="latest_neo_sdk">
  <img class="ajaxLoading" style="display:none; cursor:pointer;" title="refresh version" >
  download version <span id="download"><span id="version">x.y.z</span></span>
  of <span class="gav">
     <span style="display:none">
       <span id="group">com.sap.cloud</span>
       <span>:</span>
     </span>
     <span id="artifact">neo-java-web-sdk</span>
     <span>.</span>
     <span id="packaging">zip</span>
  </span>
  from <span class="server">&#x2026;</span>
  and unzip to &#x2026;
</span>

__unix__ `/usr/local/neo`

__windows__ `C:\usr\local\neo`


### 1.2 download the latest release of this application

<span style="display:none"><!-- understand geppaefact.js before changing anything--></span>

<span id="latest_runciter">
  <img class="ajaxLoading" style="display:none; cursor:pointer;" title="refresh version">
  download version <span id="download"><span id="version">x.y.z</span></span>
  of <span class="gav">
     <span style="display:none">
       <span id="group">net.aequologica.neo</span>
       <span>:</span>
     </span>
     <span id="artifact">runciter</span>
     <span>.</span>
     <span id="packaging">war</span>
  </span>
  from <span class="server">&#x2026;</span>
  and unzip to &#x2026;
</span>

__unix__ `/usr/local/neo/tools`

__windows__ `C:\usr\local\neo\tools`

<span style="display:none"><!-- cf.  net.aequologica.neo.geppaequo.servlet.ZeroUtils.java to understand how ${appcontext} is set --></span>

&#x2026; and rename it to `${appcontext}.war`

### 1.3 open a shell in the 'tools' sub-directory

__unix__ `cd /usr/local/neo/tools`

__windows__ `cd C:\usr\local\neo\tools`

setup proxy if needed:

__unix__

    export http_proxy=http://proxy:8080
    export https_proxy=https://proxy:8080
    export no_proxy="localhost"

__windows__

    set HTTP_PROXY_HOST=proxy
    set HTTP_PROXY_PORT=8080
    set HTTPS_PROXY_HOST=proxy
    set HTTPS_PROXY_PORT=8080
    set HTTP_NON_PROXY_HOSTS="localhost"

## 2. list the status of the application

__unix__

    neo.sh status -h ${host} -a ${account} -b ${app} -u ${user}

__windows__

    neo.bat status -h ${host} -a ${account} -b ${app} -u ${user}

## 3. deploy the new version of your application to neo

__unix__

    neo.sh deploy \
      --host              ${host} \
      --application       ${app} \
      --account           ${account} \
      --user              ${user} \
      --source            ${appcontext}.war \
      --uri-encoding      UTF-8 \
      --compression       on \
      --java-version      7 \
      --maximum-processes 2

__windows__

    neo.bat deploy ^
      --host              ${host} ^
      --application       ${app} ^
      --account           ${account} ^
      --user              ${user} ^
      --source            ${appcontext}.war ^
      --uri-encoding      UTF-8 ^
      --compression       on ^
      --java-version      7 ^
      --maximum-processes 2

On neo.ondemand.com, the (undocumented) `--url-prefix` parameter allows to set a (hopefully) meaningful URL.
  
## 4. start a new application process

__unix__

    neo.sh start -h ${host} -a ${account} -b ${app} -u ${user} --synchronous

__windows__

    neo.bat start -h ${host} -a ${account} -b ${app} -u ${user} --synchronous


## 5. soft-shutdown the application process running the old version

replace xxxxxxx by the process id returned at step _[2. list the status of the application]_

__unix__

    neo.sh disable \
      --host ${host} \
      --user ${user} \
      --application-process-id xxxxxxx

__windows__

    neo.bat disable ^
      --host ${host} ^
      --user ${user} ^
      --application-process-id xxxxxxx

## 6. wait for some time so that all working sessions finish

.
.
.

## 7. stop the application process running the old version

replace xxxxxxx by the process id returned at step _[2. list the status of the application]_

__unix__

    neo.sh stop \
      --host ${host} \
      --user ${user} \
      --application-process-id xxxxxxx

__windows__

    neo.bat stop ^
      --host ${host} ^
      --user ${user} ^
      --application-process-id xxxxxxx
