var zeroClipboardSetup = function (context) {

  if (typeof context === 'undefined') {
      return;
  }

  // cf.  http://www.jblotus.com/2011/05/24/keeping-your-handlebars-js-templates-organized/
  function getTemplateAjax(path, callback) {
    var source;
    var template;

    $.ajax({
      url: path,
      dataType: 'text',
    }).done(function( data ) {
        source    = data;
        template  = Handlebars.compile(source);

        //execute the callback if passed
        if (callback) callback(template);
    }).fail(function( jqXHR, textStatus, errorThrown) {
      alert( textStatus +' : [' + errorThrown+']');
    });
  }

  // run our template loader with callback
  getTemplateAjax(context+'scripts/geppaequo-zeroclipboard.js.handlebars', function(template) {

    $('.zeroclipboardRemoveMePlease').remove(); // need to remove what we append, otherwise it will grow infinitely (see comment just below)
	
    $('pre').each(function(index, value){
      var id = "zeroClipboard"+index;
      $(this).attr("id", id);
      var zeroclipboard_object = template({id: id});
      $(this).prev().append(zeroclipboard_object); // here we append what shall be eventually removed (see comment just above)
    });

    var zeroClipboardClient = new ZeroClipboard( $(".fa-clipboard") );

    zeroClipboardClient.on( "ready", function( readyEvent ) {

      zeroClipboardClient.on( "error", function( event ) {
        window.log( 'ZeroClipboard error of type "' + event.name + '": ' + event.message );
        ZeroClipboard.destroy();
      });

      zeroClipboardClient.on( "aftercopy", function( event ) {
        var popover = $('.pop#pop'+$(event.target).attr('data-clipboard-target'));
        if (popover) {
          popover.popover('show');
          setTimeout(function () {
            popover.popover('hide');
          }, 750);
        }
      });
    });
  });
}
