# <span style="float:left; margin-right:40px;">![C](../assets/images/alphabet/051-16th-Century-letter-c-q97-187x200.jpg "C")</span><span style="margin-left:-40px;">ertificate import</span>

Source: [&laquo; how to properly import a selfsigned certificate &raquo;](http://stackoverflow.com/questions/11617210/how-to-properly-import-a-selfsigned-certificate-into-java-keystore-that-is-avail) @  [stackoverflow.com](http://stackoverflow.com)

## 1. backup original java certificate store

__unix__

    cp "$JAVA_HOME/jre/lib/security/cacerts" \
       "$JAVA_HOME/jre/lib/security/cacerts.original"

## 2. grab certificate

__unix__

    echo -n | \
       openssl s_client \
          -connect ${pageContext.request.serverName}:${pageContext.request.serverPort} | \
       sed \
          -ne '/-BEGIN CERTIFICATE-/,/-END CERTIFICATE-/p' \
          > ./${pageContext.request.serverName}.cert

### 2a. proxy dance

if there is a proxy between you and  ${pageContext.request.serverName}

install proxytunnel from http://proxytunnel.sourceforge.net/ _(successfully used version 1.9)_

run proxytunnel daemon

__unix__

    proxytunnel -p proxy:8080 -d ${pageContext.request.serverName}:${pageContext.request.serverPort} -a 7000

then, in another shell, run a tweaked 'grab certificate' command

__unix__

    echo -n | \
       openssl s_client \
          -connect localhost:7000 | \
       sed \
          -ne '/-BEGIN CERTIFICATE-/,/-END CERTIFICATE-/p' \
          > ./${pageContext.request.serverName}.cert

## 3. import certificate into java

__unix__

    keytool \
       -import \
       -trustcacerts \
       -keystore "$JAVA_HOME/jre/lib/security/cacerts" \
       -storepass changeit \
       -noprompt \
       -alias ${pageContext.request.serverName} \
       -file ./${pageContext.request.serverName}.cert

_(you must have administrator rights for this one)_
