<%@page contentType="text/html" pageEncoding="UTF-8"
%><%@page import="net.aequologica.neo.geppaequo.webjars.WebJar"
%><%@taglib prefix="c"   uri="http://java.sun.com/jstl/core_rt"
%><%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt_rt"
%><%@taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><t:layout >

<link rel="stylesheet" href="<c:url value='<%=WebJar.locate("select2.min.css")%>' />" />
<link rel="stylesheet" href="<c:url value='<%=WebJar.locate("styles/github.css")%>' />">

<style>
select#predefinedSearchSelect {
  /*
  appearance:none;
  -moz-appearance: none;
  -webkit-appearance:none;
  */
}
/*for IE10*/
select#predefinedSearchSelect::-ms-expand {
  // display: none;
}
select#predefinedSearchSelect option { 
  color: black; 
  font-style: normal;
  // direction: ltr;
}
select#predefinedSearchSelect.placeholder, 
select#predefinedSearchSelect option.placeholder { 
  color: gray; 
  font-style: italic;
  // direction: rtl;
  font-family: 'FontAwesome', 'Open Sans', Schoolbell, Geppaequo, Inconsolata, "Helvetica Neue", Helvetica, Arial, sans-serif;
}
input:text {
  width: 100%;
}
div.form-inline#qwe {
  margin-top: .5em;
}
div.form-inline#qwe fieldset {
  margin-top: .5rem;
}
.table caption {
  display:none;
}
.table{
  border:none;
}
.table thead th {
  font-weight: normal;
  border-bottom: none;
}
.table tbody th, .table tbody td {
  border-top: none;
}
.table thead th:before {
  color: lightgray;
}
form > div {
  margin-top: 1em;
}
abbr i.fa {
  color: #FFD37F;
  font-size: 12px;
  vertical-align: text-top;
}
#msg > div > div > span,
#msg > div > div > i,
#msg > div > div > b,
#msg > div > div > a {
  padding-right: 15px;
}
</style>

<span style="float:right;" class="hidden-sm-down" >
  <span style="font-size:12px;">(&nbsp;<abbr><i class="fa fa-star"></i></abbr>&nbsp;=&nbsp;required&nbsp;)</span>
  &nbsp;
  <a class="hidden-sm-down" type="button" href="http://books.sonatype.com/mvnex-book/reference/simple-project-sect-simple-core.html#simple-project-sect-maven-coordinates" target="maven_coordinates" title="Maven Coordinates documentation @ Sonatype">
    <i class="fa fa-question-circle-o" aria-hidden="true"></i>
  </a>
</span>
<h2>Resolve Version Range</h2>

          
<form action="javascript:return false;">
  <div class="table-responsive">
    <table class="table table-sm" id="hor-minimalist-a">
      <caption></caption>
      <thead>
        <tr>
          <th  title="Group id of the artifact (required)">
            <label>group&nbsp;id&nbsp;<abbr><i class="fa fa-star"></i></abbr></label></th>
          <th  title="Artifact id of the artifact (required)">
            <label>artifact&nbsp;id&nbsp;<abbr><i class="fa fa-star"></i></abbr></label></th>
          <th  title="Classifier of the artifact (optional)">
            <label>classifier</label></th>
          <th  title="Packaging type of the artifact (optional)">
            <label>extension</label></th>
          <th  title="Version range of the artifact (required)">
            <label>
                <a  href    = "https://docs.oracle.com/middleware/1212/core/MAVEN/maven_version.htm#MAVEN402" 
                    target  = "version_range_references" 
                    style   = "cursor:help;"
                    title   = "Version Range documentation @ Oracle">
                    version&nbsp;range</a>
            &nbsp;<abbr><i class="fa fa-star"></i></abbr>
            </label>
          </th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td ><input class="form-control" type="text" id="g" data-default-value=""    value="" /></td>
          <td ><input class="form-control" type="text" id="a" data-default-value=""    value="" /></td>
          <td ><input class="form-control" type="text" id="c" data-default-value=""    value="" /></td>
          <td ><input class="form-control" type="text" id="e" data-default-value=""    value="" /></td>
          <td ><input class="form-control" type="text" id="v" data-default-value="[,)" value="" ></td>
        </tr>
      </tbody>
    </table>
    </div>

    <div class="form-inline" id="qwe">
      <fieldset class = "form-group" style="float: right;">
        <select class = "form-control"
                id    = "predefinedSearchSelect">
          <option value="-2" selected="selected" disabled class="placeholder">predefined&nbsp;searches</option><%-- &nbsp; fa-caret-down [&#xf0d7;] --%>
          <option value="-1"></option>
          <c:forEach var="predefinedSearch" items="${applicationScope.quintessence.predefinedSearches}" varStatus="i">
            <option value="${i.index}">${predefinedSearch}</option>
          </c:forEach>
        </select>
      </fieldset>
      <fieldset class="form-group">
        <label title="Repository where to search the artifact (required)">repository(ies)&nbsp;<abbr><i class="fa fa-star"></i></abbr></label>
        <select class="form-control" id="r" style="width:32em;" multiple="multiple">
          <c:forEach var="repo" items="${applicationScope.quintessence.repositoryObjects}">
          <option value="${repo.name}" title="${repo.uri}">${repo.name}</option>
          </c:forEach>
         </select>
      </fieldset>
    </div>

    <div class="form-inline">
      <fieldset id="buttons" class="form-group">
        <input class="form-control btn btn-primary" id="submit" type="submit" value="resolve" /> 
        <input class="form-control btn btn-secondary" id="reset" type="reset" value="clear results" />
      </fieldset>
    </div>

    <div id="msg" class="alert" style="display:none; margin-top:1em; "></div>

</form>

<div style="display:none">
  <pre><code id="result" class="javascript"></code></pre>
  <div class="label label-default label-info">'Location' response header</div>
  <pre id="location-header" style="overflow: hidden; font-size: smaller;" ></pre>
</div>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("highlight.pack.js")%>'/>"></script>
<script>hljs.initHighlightingOnLoad();</script>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("select2.min.js")%>'/>"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/assets/scripts/Autolinker.js'/>"></script>

<script>
  $(function() {
    $("#predefinedSearchSelect").change(function() {
        // http://jsfiddle.net/Zmf6t/
        var clearAll = false;
        var selection = $("#predefinedSearchSelect option:selected");
        if(selection.val() < 0) {
            $(this).addClass("placeholder");
            clearAll = true;
        } else {
            $(this).removeClass("placeholder")
        }
        var ids = ["g", "a", "e", "c", "v"];
        var gav = selection.text();
        if (gav == "" || clearAll) {
            for (i in ids) {
                var inp = $("#"+ids[i]);
                inp.val(inp.data('default-value'));
            }
            $('#predefinedSearchSelect option[value="-2"]').prop('selected', 'selected');
        } else {
            var a = gav.split(':');
            for (i in a) {
                var inp = $("#"+ids[i]);
                inp.val(a[i]);
            }
        }
    }); 
    $("#predefinedSearchSelect").change();
  });
  
  $("#r").change(function() {
	  $('#buttons a').remove();
	  for (rep in $(this).val()) {
		  var repo = ($(this).val()[rep]);
		  var url = "https://nexus.wdf.sap.corp:8443/nexus/index.html#view-repositories;"+repo+"~browsestorage";
		  $('#buttons').append($('<a/>').css({margin:'0 .5em'}).prop({href:url, target:repo}).html(repo + "&nbsp;<i class='fa fa-external-link' aria-hidden='true'></i>"));
	  }
  });
  
  $("form").submit(function() {
     var img = '<img class="ajaxLoading" src="'+"<c:url value='/assets/images/ajax-loader.gif'/>"+'"/>';
     $("#msg").removeClass().addClass("alert alert-info").html("resolving "+img).show();
     $("#result").parent().parent().hide();

     
     var commonQueryString = "";
     var rrr = $('#r').val();
     if (rrr) {
       if (rrr.length) {
         for (i=0;i<rrr.length;i++) {
           if (i > 0) {
             commonQueryString = commonQueryString + "&";
           }
           commonQueryString = commonQueryString + "r=" +  rrr[i];
         }
       } else {
         commonQueryString = commonQueryString + "r=" + rrr;
       }
     }
     commonQueryString = commonQueryString + "&g=" + $('#g').val();
     commonQueryString = commonQueryString + "&a=" + $('#a').val();
     commonQueryString = commonQueryString + "&e=" + $('#e').val();
     var classifier = $('#c').val();
     if (classifier) {
       commonQueryString = commonQueryString + "&c=" + classifier;
     }
     var localQueryString = "&v=" + $('#v').val();
     var theURL = '<c:url value="/api/quintessence/v1/legacy?"/>'+ commonQueryString + localQueryString;

     var artifacId = $('#a').val();
     var range = $('#v').val();
     $.ajax({
       url: theURL,
       cache: false,
       dataType: 'json',
       timeout: 30000,
       success: function(data, textStatus, jqXHR) {
         var locationHeader = jqXHR.getResponseHeader("Location");
          $("#msg")
            .removeClass()
            .addClass("alert alert-success")
            .html(
              $('<div>')
              .append($('<div>')
                .css({"font-size": "smaller", "float":"right"})
                .text(textStatus + " - " +jqXHR.status + " - " +jqXHR.statusText + ' ')
              ).append($('<div>')
                .css({"font-size": "larger"})
                  .append( $('<span>').text(artifacId + ' ' + range))
                  .append( $('<i>').addClass("fa fa-hand-o-right"))
                  .append( $('<b>').text(data.version))
                  .append( $('<a>')
                     .attr('href', locationHeader)
                     .prop("type", "button")
                     .prop("title", "download " + data.artifactId + "." + data.extension + ", version " + data.version)
                     .addClass("btn btn-secondary btn-sm")
                       .append( $('<i>').attr('id', "download").addClass("fa fa-download")))
              )
            )
            .show();
          
          var stringified = JSON.stringify(data, undefined, 2);
          stringified = stringified.replace(/\"(.*)\"\s*:/gi, "$1:");
          $("#result").empty().append(stringified).each(function(i, block) {
            hljs.highlightBlock(block);
          });
          $("#msg").show();
          $("#result").parent().parent().show();
          $("#download").show();

          $("#location-header").empty().append(locationHeader).show();
          
       },
       error: function(jqXHR, textStatus, errorThrown) {
         var format = function(text) {
           var parsed = JSON.parse(text);
           if (!parsed.message) {
             return text;
           }
           var ret = $('<ul>').append($('<li>').text(parsed.message)).append($('<li>').html(Autolinker.link( parsed.description )));
           return ret.html();
         }
         $("#msg").removeClass().addClass("alert alert-warning").html(textStatus + " - " + jqXHR.status+" - "+jqXHR.statusText + ' '+format(jqXHR.responseText)).show();

         $("#msg").show();
         $("#result").parent().parent().hide();
         $("#download").hide();
         if (errorThrown.message) {
           $("#result").empty().text(errorThrown.message).parent().show();
         } else if (errorThrown != jqXHR.statusText) {
           $("#result").empty().text(errorThrown).parent().show();
         } else {
           $("#result").empty();
         }
       }
     });
     return false;
  });

  $("form").bind("reset", function() {
      $("#msg").hide();
      $("#result").parent().parent().hide();
      $("#download").hide();
      return false;
  });
  
  
  if (typeof String.prototype.startsWith != 'function') {
  String.prototype.startsWith = function (str){
      return this.slice(0, str.length) == str;
    };
  }
  
  $(document).ready(function() {
    
    $("#r").select2();
    
    $("#r").val("");
    var ids = ["g", "a", "e", "c", "v"];
    for (i in ids) {
        var inp = $("#"+ids[i]);
        inp.val(inp.data('default-value'));
    }
  });
    

</script>
