/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.quintessence.config;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.aequologica.neo.geppaequo.config.AbstractConfig;
import net.aequologica.neo.geppaequo.config.Config;
import org.weakref.jmx.Managed;

@Config(name="quintessence")
public final class QuintessenceConfig
extends AbstractConfig {
    private List<Repo> repos = null;
    private List<String> predefinedSearches = null;
    private Repo snapshotRepo = null;
    private Repo releaseRepo = null;

    @Managed
    public List<String> getRepositories() {
        return this.getStringList("repositories");
    }

    @Managed
    public List<String> getPredefinedSearches() {
        return this.getStringList("predefinedSearches");
    }

    @Managed
    public String getSnapshots() {
        return this.get("snapshots");
    }

    @Managed
    public String getReleases() {
        return this.get("releases");
    }

    List<Repo> parse(List<String> repositories) {
        if (repositories == null) {
            return Collections.emptyList();
        }
        ArrayList<Repo> repos = new ArrayList<Repo>(repositories.size());
        for (String repository : repositories) {
            String uriAsString;
            String name;
            String[] split = repository.split("::");
            if (split.length <= 0 || (name = split[0]) == null || name.length() <= 0) continue;
            URI uri = null;
            if (split.length <= 2 || (uriAsString = split[2]) == null || uriAsString.length() <= 0 || (uri = URI.create(uriAsString)) == null) continue;
            Repo repo = new Repo(name, uri);
            repos.add(repo);
            if (repo.name.equals(this.getSnapshots())) {
                this.snapshotRepo = repo;
                continue;
            }
            if (!repo.name.equals(this.getReleases())) continue;
            this.releaseRepo = repo;
        }
        return repos;
    }

    public List<Repo> getRepositoryObjects() {
        if (this.repos == null || this.repos.size() == 0) {
            List repositories = this.getStringList("repositories");
            this.repos = this.parse(repositories);
        }
        return this.repos;
    }

    public Repo getSnapshotRepo() {
        this.getRepositoryObjects();
        return this.snapshotRepo;
    }

    public Repo getReleaseRepo() {
        this.getRepositoryObjects();
        return this.releaseRepo;
    }

    public Repo getRepo(int index) {
        List<Repo> repos = this.getRepositoryObjects();
        if (repos == null) {
            return null;
        }
        if (index >= repos.size()) {
            return null;
        }
        return repos.get(index);
    }

    public static class Repo {
        String name;
        URI uri;

        Repo(String name, URI url) {
            this.name = name;
            this.uri = url;
        }

        public String getName() {
            return this.name;
        }

        public URI getUri() {
            return this.uri;
        }

        public String toString() {
            return "Repo [name=" + this.name + ", uri=" + this.uri + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.toString().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Repo other = (Repo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.uri == null ? other.uri != null : !this.uri.toString().equals(other.uri.toString()));
        }
    }
}

