package net.aequologica.neo.quintessence.config;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.weakref.jmx.Managed;

import net.aequologica.neo.geppaequo.config.AbstractConfig;
import net.aequologica.neo.geppaequo.config.Config;

@Config(name = "quintessence")
public final class QuintessenceConfig extends AbstractConfig {

    public QuintessenceConfig() throws IOException {
        super();
    }
    
    private List<Repo> repos = null;
    private List<String> predefinedSearches = null;
    private Repo snapshotRepo = null;
    private Repo releaseRepo = null;
    
    @Managed
    public List<String> getRepositories() {
        return getStringList("repositories");
    }

    @Managed
    public List<String> getPredefinedSearches() {
        return getStringList("predefinedSearches");
    }

    @Managed
    public String getSnapshots() {
        return get("snapshots");
    }

    @Managed
    public String getReleases() {
        return get("releases");
    }

    public static class Repo {
        String name;
        URI uri;
        Repo(String name, URI url){
            this.name = name;
            this.uri = url;
        }
        public String getName() {
            return name;
        }
        public URI getUri() {
            return uri;
        }
        @Override
        public String toString() {
            return "Repo [name=" + name + ", uri=" + uri + "]";
        }
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((name == null) ? 0 : name.hashCode());
            result = prime * result + ((uri == null) ? 0 : uri.toString().hashCode());
            return result;
        }
        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (getClass() != obj.getClass())
                return false;
            Repo other = (Repo) obj;
            if (name == null) {
                if (other.name != null)
                    return false;
            } else if (!name.equals(other.name))
                return false;
            if (uri == null) {
                if (other.uri != null)
                    return false;
            } else if (!uri.toString().equals(other.uri.toString()))
                return false;
            return true;
        }
    }

    List<Repo> parse(List<String> repositories) {
        if (repositories == null) {
            return Collections.emptyList();
        }
        ArrayList<Repo> repos = new ArrayList<>(repositories.size());
        for (String repository : repositories) {
            String[] split = repository.split("::");
            if (split.length > 0){
                String name = split[0];
                if (name!= null && name.length()>0) {
                    URI uri = null;
                    if (split.length > 2){
                        String uriAsString = split[2];
                        if (uriAsString!= null && uriAsString.length()>0) {
                            uri = URI.create(uriAsString);
                            if (uri != null) {
                                Repo repo = new Repo(name, uri);
                                repos.add(repo);
                                if (repo.name.equals(getSnapshots())) {
                                    snapshotRepo = repo;
                                } else if (repo.name.equals(getReleases())) {
                                    releaseRepo = repo;
                                } 
                            }
                        }
                    }
                }
            }
        }
        return repos;
    }
    
    public List<Repo> getRepositoryObjects() {
        if (repos == null || repos.size()==0) {
            List<String> repositories = getStringList("repositories");
            repos = parse(repositories);
        }
        return repos;
    }
    
    public Repo getSnapshotRepo() {
        getRepositoryObjects();
        return snapshotRepo;
    }
    
    public Repo getReleaseRepo() {
        getRepositoryObjects();
        return releaseRepo;
    }
    
    public Repo getRepo(int index) {
        List<Repo> repos = getRepositoryObjects();
        if (repos == null) {
            return null;
        }
        if (index>=repos.size()) {
            return null;
        }
        return repos.get(index);
    }

}
