/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.quintessence.jaxrs;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.aequologica.neo.quintessence.aether.Booter;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.version.Version;

@Singleton
@Path(value="v1")
public class Resource {
    VersionRangeResolverImpl versionRangeResolver = new VersionRangeResolverImpl();

    @GET
    @Produces(value={"text/plain"})
    public Response ping() {
        return Response.ok().entity((Object)"aether-api is here").build();
    }

    @GET
    @Path(value="/repositories/{repositoryId: .+}/groups/{groupId: .+}/artifacts/{artifactId: .+}/versions/{versionRange: .+}/extensions/{extension: .+}")
    @Produces(value={"application/json"})
    public Response resolve(@Context HttpServletResponse httpServletResponse, @PathParam(value="repositoryId") String repositoryId, @PathParam(value="groupId") String groupId, @PathParam(value="artifactId") String artifactId, @PathParam(value="version") String versionRange, @PathParam(value="extension") String extension) {
        return this.legacy(httpServletResponse, Arrays.asList(repositoryId), groupId, artifactId, versionRange == null ? "[,)" : versionRange, extension, null, null);
    }

    @GET
    @Path(value="/legacy")
    @Produces(value={"application/json"})
    public Response legacy(@Context HttpServletResponse httpServletResponse, @QueryParam(value="r") List<String> repositories, @QueryParam(value="g") String groupId, @QueryParam(value="a") String artifactId, @QueryParam(value="v") String versionRange, @QueryParam(value="e") String extension, @QueryParam(value="c") String classifier, @QueryParam(value="p") String packaging) {
        try {
            RepositoryHolder repositoryHolder = new RepositoryHolder();
            Artifact artifact = this.versionRangeResolver.resolve(repositories, groupId, artifactId, classifier, extension, versionRange, repositoryHolder);
            String downloadURI = this.buildDownloadURI(URI.create(repositoryHolder.remoteRepository.getUrl()), artifact);
            httpServletResponse.setHeader("Location", downloadURI);
            return Response.ok().entity((Object)artifact).build();
        }
        catch (MyIllegalArgumentException iae) {
            return Response.status((int)422).entity((Object)new ExceptionInfo(422, iae.getMessage(), iae.getDescription())).type("application/json").build();
        }
        catch (VersionRangeResolutionException vrre) {
            return Response.status((int)404).entity((Object)new ExceptionInfo(404, vrre.getMessage(), null)).type("application/json").build();
        }
        catch (VersionResolutionException vre) {
            return Response.status((int)404).entity((Object)new ExceptionInfo(404, vre.getMessage(), null)).type("application/json").build();
        }
        catch (Throwable t) {
            return Response.status((int)500).entity((Object)new ExceptionInfo(500, t.getMessage(), null)).type("application/json").build();
        }
    }

    private String buildDownloadURI(URI nexusURI, Artifact artifact) throws Exception {
        URI merged = new URI(nexusURI.getScheme(), nexusURI.getUserInfo(), nexusURI.getHost(), nexusURI.getPort(), nexusURI.getPath(), null, null);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)merged);
        for (String bout_de_groupe : artifact.getGroupId().split("\\.")) {
            uriBuilder.segment(new String[]{bout_de_groupe});
        }
        uriBuilder.segment(new String[]{artifact.getArtifactId()});
        uriBuilder.segment(new String[]{artifact.getBaseVersion()});
        StringBuilder filename = new StringBuilder();
        filename.append(artifact.getArtifactId());
        filename.append("-");
        filename.append(artifact.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            filename.append("-");
            filename.append(artifact.getClassifier());
        }
        filename.append(".");
        filename.append(artifact.getExtension());
        uriBuilder.segment(new String[]{filename.toString()});
        String repositoryPath = uriBuilder.toString();
        return repositoryPath;
    }

    public static class StringUtils {
        public static String trimToEmpty(String string) {
            return string == null ? "" : string.trim();
        }

        public static boolean isEmpty(String string) {
            if (string == null) {
                return true;
            }
            return string.trim().length() == 0;
        }
    }

    static class VersionRangeResolverImpl {
        VersionRangeResolverImpl() {
        }

        public Artifact resolve(List<String> repositories, String groupId, String artifactId, String classifier, String extension, String version, RepositoryHolder repositoryHolder) throws IOException, VersionRangeResolutionException, VersionResolutionException {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
            if (repositories.size() == 0 || StringUtils.isEmpty(artifact.getGroupId()) || StringUtils.isEmpty(artifact.getArtifactId()) || StringUtils.isEmpty(artifact.getVersion())) {
                throw new IllegalArgumentException("at least one of [ group id | artifact id | version range | repository ] is missing.");
            }
            String[] versions = VersionRangeResolverImpl.parseVersionRange(artifact.getVersion());
            DefaultArtifact ret = artifact;
            try (Booter booter = new Booter();){
                DefaultArtifact artifactResult;
                RepositorySystem system = booter.newRepositorySystem();
                DefaultRepositorySystemSession session = booter.newRepositorySystemSession(system);
                VersionRangeRequest rangeRequest = new VersionRangeRequest();
                rangeRequest.setArtifact((Artifact)artifact);
                List<RemoteRepository> newRepositories = booter.newRepositories(system, (RepositorySystemSession)session);
                if (repositories == null || repositories.size() == 0) {
                    rangeRequest.setRepositories(newRepositories);
                }
                for (RemoteRepository remoteRepository : newRepositories) {
                    if (!repositories.contains(remoteRepository.getId())) continue;
                    rangeRequest.addRepository(remoteRepository);
                }
                VersionRangeResult rangeResult = system.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
                Version lowestVersion = rangeResult.getLowestVersion();
                Version newestVersion = rangeResult.getHighestVersion();
                if (newestVersion == null) {
                    throw new VersionRangeResolutionException(rangeResult);
                }
                repositoryHolder.repositoryId = rangeResult.getRepository(newestVersion).getId();
                for (RemoteRepository remoteRepository : newRepositories) {
                    if (!remoteRepository.getId().equals(repositoryHolder.repositoryId)) continue;
                    repositoryHolder.remoteRepository = remoteRepository;
                }
                String resolvedSnapshotVersion = null;
                if (newestVersion.toString().endsWith("SNAPSHOT")) {
                    VersionRequest versionRequest = new VersionRequest();
                    ret = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), newestVersion.toString());
                    versionRequest.setArtifact((Artifact)ret);
                    versionRequest.addRepository(repositoryHolder.remoteRepository);
                    VersionResult versionResult = system.resolveVersion((RepositorySystemSession)session, versionRequest);
                    resolvedSnapshotVersion = versionResult.getVersion();
                }
                DefaultArtifact defaultArtifact = artifactResult = new DefaultArtifact(ret.getGroupId(), ret.getArtifactId(), ret.getClassifier(), ret.getExtension(), resolvedSnapshotVersion == null ? newestVersion.toString() : resolvedSnapshotVersion);
                return defaultArtifact;
            }
        }

        static String[] parseVersionRange(String versionRange) {
            versionRange = StringUtils.trimToEmpty(versionRange);
            String reason = null;
            boolean i = false;
            if (i < true) {
                if (versionRange.length() < 3) {
                    reason = "less than 3 characters";
                } else {
                    if ("LATEST".equals(versionRange)) {
                        return new String[]{"", versionRange};
                    }
                    if ("RELEASE".equals(versionRange)) {
                        return new String[]{"", versionRange};
                    }
                    if (versionRange.endsWith("SNAPSHOT")) {
                        return new String[]{"", versionRange};
                    }
                    String[] versions = versionRange.split(",");
                    if (versions.length == 1) {
                        reason = "must contain a ',' separator";
                    } else if (versions.length > 2) {
                        reason = "can contain only one ',' separator";
                    } else if (versions[0].charAt(0) != '[' && versions[0].charAt(0) != '(') {
                        reason = "must start with '[' or '('";
                    } else {
                        versions[0] = StringUtils.trimToEmpty(versions[0].substring(1));
                        if (versions[1].charAt(versions[1].length() - 1) != ']' && versions[1].charAt(versions[1].length() - 1) != ')') {
                            reason = "must end with ']' or ')'";
                        } else {
                            versions[1] = StringUtils.trimToEmpty(versions[1].substring(0, versions[1].length() - 1));
                            return versions;
                        }
                    }
                }
            }
            if (reason != null) {
                String prefix = "not a valid version range : \u00ab " + versionRange + " \u00bb ";
                String suffix = " cf. https://docs.oracle.com/middleware/1212/core/MAVEN/maven_version.htm#MAVEN402";
                throw new MyIllegalArgumentException(prefix + reason, suffix);
            }
            return null;
        }

        public long[] parseTimeStampBuildNumberFromSnapshot(String snapshotVersion) {
            long[] ret = new long[]{0L, 0L};
            Pattern p = Pattern.compile("([^- ]+)-([^- ]+)-([^- ]+)");
            Matcher m = p.matcher(snapshotVersion);
            if (!m.matches() || m.groupCount() != 3) {
                throw new MyIllegalArgumentException("Bad snapshotVersion coordinates \u00ab " + snapshotVersion + "\u00bb", "expected format is <non snapshot version>-<timestamp>-<build number>");
            }
            String timestamp = m.group(2);
            int dot = timestamp.indexOf(46);
            if (dot != -1) {
                timestamp = timestamp.substring(0, dot) + timestamp.substring(dot + 1);
            }
            ret[0] = Long.parseLong(timestamp);
            ret[1] = Long.parseLong(m.group(3));
            return ret;
        }
    }

    public class RepositoryHolder {
        public String repositoryId;
        public RemoteRepository remoteRepository;
    }

    static class MyIllegalArgumentException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 8668098471962316302L;
        private final String d;

        MyIllegalArgumentException(String s, String d) {
            super(s);
            this.d = d;
        }

        String getDescription() {
            return this.d;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
    @XmlRootElement
    public class ExceptionInfo {
        private int status;
        private String msg;
        private String desc;

        public ExceptionInfo(int status, String msg, String desc) {
            this.status = status;
            this.msg = msg;
            this.desc = desc;
        }

        @XmlElement
        public int getStatus() {
            return this.status;
        }

        @XmlElement
        public String getMessage() {
            return this.msg;
        }

        @XmlElement
        public String getDescription() {
            return this.desc;
        }
    }
}

