package net.aequologica.neo.quintessence.jaxrs;

import java.util.Comparator;
import java.util.List;
import java.util.Map.Entry;

public class QueryParameterComparator implements Comparator<Entry<String, List<String>>> {

    public static enum rgaecv {
        r, g, a, e, c, v
    }

    @Override
    public int compare(final Entry<String, List<String>> e1, final Entry<String, List<String>> e2) {
        final int ordinalValue1 = calculateOrdinalValueOfQueryParameter(e1);
        final int ordinalValue2 = calculateOrdinalValueOfQueryParameter(e2);
        return ordinalValue1 - ordinalValue2;
    }

    public int calculateOrdinalValueOfQueryParameter(final Entry<String, List<String>> e1) {
        try {
            return rgaecv.valueOf(new String(new char[] { e1.getKey().charAt(0) })).ordinal();
        } catch (final Exception e) {
        	String msg = "The query parameter '" + e1.getKey() + "' is not supported";
            throw new RuntimeException(msg, e);
        }
    }

}
