/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.quintessence.aether.utils;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TempDirectory {
    final Path path;

    public TempDirectory(String name) throws IOException {
        this.path = Files.createTempDirectory(name, new FileAttribute[0]);
    }

    public Path getPath() {
        return this.path;
    }

    public void delete() throws IOException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return super.postVisitDirectory(dir, exc);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return super.visitFile(file, attrs);
            }
        });
    }
}

