/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.quintessence.jaxrs;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.aequologica.neo.quintessence.aether.Booter;
import net.aequologica.neo.quintessence.aether.utils.ConsoleDependencyGraphDumper;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.version.Version;

@Singleton
@Path(value="/")
public class Resource {
    VersionRangeResolverImpl versionRangeResolver = new VersionRangeResolverImpl();

    @GET
    @Produces(value={"text/plain"})
    public Response ping() {
        return Response.ok().entity((Object)"aether-api is here").build();
    }

    @GET
    @Path(value="/{groupId: .+}/{artifactId : .+}")
    @Produces(value={"text/plain"})
    public Response latest(@PathParam(value="groupId") String groupId, @PathParam(value="artifactId") String artifactId) throws Exception {
        System.out.println(Resource.class.getSimpleName());
        try (Booter booter = new Booter();){
            RepositorySystem system = booter.newRepositorySystem();
            DefaultRepositorySystemSession session = booter.newRepositorySystemSession(system);
            DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":[0,)");
            VersionRangeRequest rangeRequest = new VersionRangeRequest();
            rangeRequest.setArtifact((Artifact)artifact);
            rangeRequest.setRepositories(booter.newRepositories(system, (RepositorySystemSession)session));
            VersionRangeResult rangeResult = system.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
            Version newestVersion = rangeResult.getHighestVersion();
            System.out.println("Newest version " + newestVersion + " from repository " + rangeResult.getRepository(newestVersion));
            Response response = Response.ok().entity((Object)newestVersion.toString()).build();
            return response;
        }
    }

    @GET
    @Path(value="/{groupId: .+}/{artifactId : .+}/{version : .+}")
    @Produces(value={"text/plain"})
    public Response tree(@PathParam(value="groupId") String groupId, @PathParam(value="artifactId") String artifactId, @PathParam(value="version") String version) throws Exception {
        System.out.println("------------------------------------------------------------");
        System.out.println(Resource.class.getSimpleName());
        try (Booter booter = new Booter();){
            RepositorySystem system = booter.newRepositorySystem();
            DefaultRepositorySystemSession session = booter.newRepositorySystemSession(system);
            DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + version);
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
            collectRequest.setRepositories(booter.newRepositories(system, (RepositorySystemSession)session));
            CollectResult collectResult = system.collectDependencies((RepositorySystemSession)session, collectRequest);
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            collectResult.getRoot().accept((DependencyVisitor)new ConsoleDependencyGraphDumper(out));
            Response response = Response.ok().entity((Object)sw.toString()).build();
            return response;
        }
    }

    @GET
    @Path(value="/legacy")
    @Produces(value={"application/json"})
    public Response resolve(@Context HttpServletResponse httpServletResponse, @QueryParam(value="r") List<String> repositories, @QueryParam(value="g") String groupId, @QueryParam(value="a") String artifactId, @QueryParam(value="e") String extension, @QueryParam(value="c") String classifier, @QueryParam(value="v") String versionRange, @QueryParam(value="p") String packaging) {
        try {
            RepositoryHolder repositoryHolder = new RepositoryHolder();
            Artifact artifact = this.versionRangeResolver.resolve(repositories, groupId, artifactId, classifier, extension, versionRange, repositoryHolder);
            String downloadURI = this.buildDownloadURI(URI.create(repositoryHolder.remoteRepository.getUrl()), artifact);
            httpServletResponse.setHeader("Location", downloadURI);
            return Response.ok().entity((Object)artifact).build();
        }
        catch (IllegalArgumentException iae) {
            return Response.status((int)422).entity((Object)iae.getMessage()).build();
        }
        catch (VersionRangeResolutionException vrre) {
            return Response.status((int)404).entity((Object)vrre.getMessage()).build();
        }
        catch (VersionResolutionException vre) {
            return Response.status((int)404).entity((Object)vre.getMessage()).build();
        }
        catch (Throwable t) {
            return Response.status((int)500).entity((Object)t.getMessage()).build();
        }
    }

    private String buildDownloadURI(URI nexusURI, Artifact artifact) throws Exception {
        URI merged = new URI(nexusURI.getScheme(), nexusURI.getUserInfo(), nexusURI.getHost(), nexusURI.getPort(), nexusURI.getPath(), null, null);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)merged);
        for (String bout_de_groupe : artifact.getGroupId().split("\\.")) {
            uriBuilder.segment(new String[]{bout_de_groupe});
        }
        uriBuilder.segment(new String[]{artifact.getArtifactId()});
        uriBuilder.segment(new String[]{artifact.getBaseVersion()});
        StringBuilder filename = new StringBuilder();
        filename.append(artifact.getArtifactId());
        filename.append("-");
        filename.append(artifact.getVersion());
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            filename.append("-");
            filename.append(artifact.getClassifier());
        }
        filename.append(".");
        filename.append(artifact.getExtension());
        uriBuilder.segment(new String[]{filename.toString()});
        String repositoryPath = uriBuilder.toString();
        return repositoryPath;
    }

    public static class StringUtils {
        public static String trimToEmpty(String string) {
            return string == null ? "" : string.trim();
        }

        public static boolean isEmpty(String string) {
            if (string == null) {
                return true;
            }
            return string.trim().length() == 0;
        }
    }

    private class VersionRangeResolverImpl {
        private VersionRangeResolverImpl() {
        }

        public Artifact resolve(List<String> repositories, String groupId, String artifactId, String classifier, String extension, String version, RepositoryHolder repositoryHolder) throws IOException, VersionRangeResolutionException, VersionResolutionException {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
            if (repositories.size() == 0 || StringUtils.isEmpty(artifact.getGroupId()) || StringUtils.isEmpty(artifact.getArtifactId()) || StringUtils.isEmpty(artifact.getVersion())) {
                throw new IllegalArgumentException("at least one of [ group id | artifact id | version range | repository ] is missing.");
            }
            if (!this.isVersionRange(artifact.getVersion())) {
                throw new IllegalArgumentException("\u00ab " + artifact.getVersion() + " \u00bb does not seem to be a valid version range; cf. https://docs.oracle.com/middleware/1212/core/MAVEN/maven_version.htm#MAVEN402 ");
            }
            DefaultArtifact ret = artifact;
            try (Booter booter = new Booter();){
                DefaultArtifact artifactResult;
                RepositorySystem system = booter.newRepositorySystem();
                DefaultRepositorySystemSession session = booter.newRepositorySystemSession(system);
                VersionRangeRequest rangeRequest = new VersionRangeRequest();
                rangeRequest.setArtifact((Artifact)artifact);
                List<RemoteRepository> newRepositories = booter.newRepositories(system, (RepositorySystemSession)session);
                if (repositories == null || repositories.size() == 0) {
                    rangeRequest.setRepositories(newRepositories);
                }
                for (RemoteRepository remoteRepository : newRepositories) {
                    if (!repositories.contains(remoteRepository.getId())) continue;
                    rangeRequest.addRepository(remoteRepository);
                }
                VersionRangeResult rangeResult = system.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
                Version lowestVersion = rangeResult.getLowestVersion();
                Version newestVersion = rangeResult.getHighestVersion();
                if (newestVersion == null) {
                    throw new VersionRangeResolutionException(rangeResult);
                }
                repositoryHolder.repositoryId = rangeResult.getRepository(newestVersion).getId();
                for (RemoteRepository remoteRepository : newRepositories) {
                    if (!remoteRepository.getId().equals(repositoryHolder.repositoryId)) continue;
                    repositoryHolder.remoteRepository = remoteRepository;
                }
                String resolvedSnapshotVersion = null;
                if (newestVersion.toString().endsWith("SNAPSHOT")) {
                    VersionRequest versionRequest = new VersionRequest();
                    ret = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), newestVersion.toString());
                    versionRequest.setArtifact((Artifact)ret);
                    versionRequest.addRepository(repositoryHolder.remoteRepository);
                    VersionResult versionResult = system.resolveVersion((RepositorySystemSession)session, versionRequest);
                    resolvedSnapshotVersion = versionResult.getVersion();
                }
                DefaultArtifact defaultArtifact = artifactResult = new DefaultArtifact(ret.getGroupId(), ret.getArtifactId(), ret.getClassifier(), ret.getExtension(), resolvedSnapshotVersion == null ? newestVersion.toString() : resolvedSnapshotVersion);
                return defaultArtifact;
            }
        }

        boolean isVersionRange(String versionRange) {
            if ((versionRange = StringUtils.trimToEmpty(versionRange)).length() < 3) {
                return false;
            }
            if ("LATEST".equals(versionRange)) {
                return true;
            }
            if ("RELEASE".equals(versionRange)) {
                return true;
            }
            if (versionRange.endsWith("SNAPSHOT")) {
                return true;
            }
            if (versionRange.charAt(0) != '[' && versionRange.charAt(0) != '(') {
                return false;
            }
            if (versionRange.charAt(versionRange.length() - 1) != ']' && versionRange.charAt(versionRange.length() - 1) != ')') {
                return false;
            }
            return -1 != versionRange.indexOf(44);
        }

        public long[] parseTimeStampBuildNumberFromSnapshot(String snapshotVersion) {
            long[] ret = new long[]{0L, 0L};
            Pattern p = Pattern.compile("([^- ]+)-([^- ]+)-([^- ]+)");
            Matcher m = p.matcher(snapshotVersion);
            if (!m.matches() || m.groupCount() != 3) {
                throw new IllegalArgumentException("Bad snapshotVersion coordinates " + snapshotVersion + ", expected format is <non snapshot version>-<timestamp>-<build number>");
            }
            String timestamp = m.group(2);
            int dot = timestamp.indexOf(46);
            if (dot != -1) {
                timestamp = timestamp.substring(0, dot) + timestamp.substring(dot + 1);
            }
            ret[0] = Long.parseLong(timestamp);
            ret[1] = Long.parseLong(m.group(3));
            return ret;
        }
    }

    public class RepositoryHolder {
        public String repositoryId;
        public RemoteRepository remoteRepository;
    }
}

