/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.quintessence.aether.utils;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class ConsoleTransferListener
extends AbstractTransferListener {
    private PrintStream out;
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;

    public ConsoleTransferListener() {
        this(null);
    }

    public ConsoleTransferListener(PrintStream out) {
        this.out = out != null ? out : System.out;
    }

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        this.out.println(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
    }

    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.out.print(buffer);
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                long bytes = contentLength - resource.getResumeOffset();
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)bytes / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.out.println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
        }
    }

    public void transferFailed(TransferEvent event) {
        this.transferCompleted(event);
        if (!(event.getException() instanceof MetadataNotFoundException)) {
            event.getException().printStackTrace(this.out);
        }
    }

    private void transferCompleted(TransferEvent event) {
        this.downloads.remove(event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        buffer.append('\r');
        this.out.print(buffer);
    }

    public void transferCorrupted(TransferEvent event) {
        event.getException().printStackTrace(this.out);
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

