/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.quintessence.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aequologica.neo.geppaequo.config.AbstractConfig;
import net.aequologica.neo.geppaequo.config.Config;
import org.weakref.jmx.Managed;

@Config(name="quintessence")
public final class QuintessenceConfig
extends AbstractConfig {
    private ArrayList<Repo> repos = null;

    @Managed
    public List<String> getRepositories() {
        return this.getStringList("repositories");
    }

    static ArrayList<Repo> parse(List<String> repositories) {
        if (repositories == null) {
            return null;
        }
        ArrayList<Repo> repos = new ArrayList<Repo>(repositories.size());
        for (String repository : repositories) {
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(repository.split("::")));
            if (split.size() <= 0) continue;
            String name = split.get(0);
            split.remove(0);
            String url = "";
            if (split.size() > 0) {
                split.remove(0);
                StringBuilder sb = new StringBuilder();
                for (String s : split) {
                    sb.append(s);
                }
                url = sb.toString();
            }
            repos.add(new Repo(name, url));
        }
        return repos;
    }

    public ArrayList<Repo> getRepos() {
        if (this.repos == null || this.repos.size() == 0) {
            List repositories = this.getStringList("repositories");
            this.repos = QuintessenceConfig.parse(repositories);
        }
        return this.repos;
    }

    public Repo getRepo(int index) {
        ArrayList<Repo> repos = this.getRepos();
        if (repos == null) {
            return null;
        }
        if (index >= repos.size()) {
            return null;
        }
        return repos.get(index);
    }

    public static class Repo {
        String name;
        String url;

        Repo(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Repo other = (Repo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }
}

