/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.quintessence.aether;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.quintessence.aether.utils.ConsoleRepositoryListener;
import net.aequologica.neo.quintessence.aether.utils.ConsoleTransferListener;
import net.aequologica.neo.quintessence.aether.utils.TempDirectory;
import net.aequologica.neo.quintessence.config.QuintessenceConfig;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;

public class Booter
implements Closeable {
    private final TempDirectory tempDirectory = new TempDirectory("local-repo");

    public RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                exception.printStackTrace();
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) throws IOException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(this.tempDirectory.toString());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        session.setDependencyGraphTransformer(null);
        return session;
    }

    public List<RemoteRepository> newRepositories(RepositorySystem system, RepositorySystemSession session) {
        RemoteRepository central = new RemoteRepository.Builder("central", "default", "http://central.maven.org/maven2/").build();
        ArrayList<RemoteRepository> ret = new ArrayList<RemoteRepository>();
        List<String> repositories = ((QuintessenceConfig)((Object)ConfigRegistry.getConfig(QuintessenceConfig.class))).getRepositories();
        for (String repository : repositories) {
            System.out.println(repository);
            String[] items = repository.split("::");
            ret.add(new RemoteRepository.Builder(items[0], items[1], items[2]).build());
        }
        return ret;
    }

    private RemoteRepository newCentralRepository() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.tempDirectory.delete();
    }
}

