package net.aequologica.neo.quintessence.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.weakref.jmx.Managed;

import net.aequologica.neo.geppaequo.config.AbstractConfig;
import net.aequologica.neo.geppaequo.config.Config;

@Config(name = "quintessence")
public final class QuintessenceConfig extends AbstractConfig {

    public QuintessenceConfig() throws IOException {
        super();
    }
    
    private ArrayList<Repo> repos = null;
    
    @Managed
    public List<String> getRepositories() {
        return getStringList("repositories");
    }

    public static class Repo {
        String name;
        String url;
        Repo(String name, String url){
            this.name = name;
            this.url = url;
        }
        public String getName() {
            return name;
        }
        public String getUrl() {
            return url;
        }
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((name == null) ? 0 : name.hashCode());
            result = prime * result + ((url == null) ? 0 : url.hashCode());
            return result;
        }
        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (getClass() != obj.getClass())
                return false;
            Repo other = (Repo) obj;
            if (name == null) {
                if (other.name != null)
                    return false;
            } else if (!name.equals(other.name))
                return false;
            if (url == null) {
                if (other.url != null)
                    return false;
            } else if (!url.equals(other.url))
                return false;
            return true;
        }
    }

    static ArrayList<Repo> parse(List<String> repositories) {
        if (repositories == null) {
            return null;
        }
        ArrayList<Repo> repos = new ArrayList<>(repositories.size());
        for (String repository : repositories) {
            ArrayList<String> split = new ArrayList<>(Arrays.asList(repository.split("::")));
            if (split.size() > 0){
                String name = split.get(0);
                split.remove(0);
                String url = "";
                if (split.size() > 0){
                    split.remove(0);
                    StringBuilder sb = new StringBuilder();
                    for (String s : split) {
                        sb.append(s);
                    }
                    url = sb.toString();
                }
                repos.add(new Repo(name, url));
            }
        }
        return repos;
    }
    public ArrayList<Repo> getRepos() {
        if (repos == null || repos.size()==0) {
            List<String> repositories = getStringList("repositories");
            repos = parse(repositories);
        }
        return repos;
    }
    
    public Repo getRepo(int index) {
        ArrayList<Repo> repos = getRepos();
        if (repos == null) {
            return null;
        }
        if (index>=repos.size()) {
            return null;
        }
        return repos.get(index);
    }

}
