// http://www.adequatelygood.com/JavaScript-Module-Pattern-In-Depth.html
;var Geppaequo = (function ($) {

  var _this_ = {
    contextPath : "/"
  };

  // setContextPath
  _this_.setContextPath = function(contextPathParam) {
      if (!_.isString(contextPathParam)) {
          return;
      }
      if (contextPathParam.endsWith('/')) {
          this.contextPath = contextPathParam;
      } else {
          this.contextPath = contextPathParam + '/';
      }
  }
  
  // load and display show header and footer
  _this_.showBody = function(whenHeaderAndFooterAreLoaded) {
    if (typeof whenHeaderAndFooterAreLoaded === "undefined" || !whenHeaderAndFooterAreLoaded) {
      $('body div#loading').css('display', 'none');
      return;
    }
    // load geppaequo header and footer for modules
    var grandeLassitudeHeader = null;
    var grandeLassitudeFooter = null;
    var pathname = window.location.pathname;

    if (pathname.indexOf(this.contextPath + 'modules/') != -1) {
      if (pathname.endsWith('/index.jsp')) {
        grandeLassitudeHeader = pathname.replace('/modules/', '/stnemucod/document/modules/').replace('/index.jsp', '/header.html');
        grandeLassitudeFooter = pathname.replace('/modules/', '/stnemucod/document/modules/').replace('/index.jsp', '/footer.html');
      } else if (pathname.endsWith('/')) {
        grandeLassitudeHeader = pathname.replace('/modules/', '/stnemucod/document/modules/').replace(/\/$/g, '/header.html');
        grandeLassitudeFooter = pathname.replace('/modules/', '/stnemucod/document/modules/').replace(/\/$/g, '/footer.html');
      }
    } else if (pathname === this.contextPath + 'index.jsp') {
        grandeLassitudeHeader = pathname.replace('/index.jsp', '/stnemucod/document/home/header.html');
        grandeLassitudeFooter = pathname.replace('/index.jsp', '/stnemucod/document/home/footer.html');
    } else if (pathname === this.contextPath) {
        grandeLassitudeHeader = pathname.replace(/\/$/g, '/stnemucod/document/home/header.html');
        grandeLassitudeFooter = pathname.replace(/\/$/g, '/stnemucod/document/home/footer.html');
    }

    var countDownLatch = {
      count: 0,
      check: function() {
        this.count--;
        if (this.count == 0) {
          this.showContainer();
        }
      },
      showContainer: function() {
        $('body div#loading').css('display', 'none');
        $('body div#loaded').css('visibility', 'visible');
      }
    };

    countDownLatch.count++;

    if (grandeLassitudeHeader != null) {
      countDownLatch.count ++;
      $("#geppaequo-header").load(grandeLassitudeHeader, function(response, status, xhr) {
        countDownLatch.check();
      });
    }

    if (grandeLassitudeFooter != null) {
      countDownLatch.count ++;
      $("#geppaequo-footer").load(grandeLassitudeFooter, function(response, status, xhr) {
        countDownLatch.check();
      });
    }

    countDownLatch.check();
  };

  return _this_;

}(jQuery));
