var zeroModule = (function () {

  this.artifactServer = {title:"n/a", URL:"javascript:void(0)"};

  var hostName, nexusBase, redirectJSP;

  this.init = function(hostNameParam, nexusBaseParam, redirectJSPParam ) {
    hostName    = hostNameParam;
    nexusBase   = nexusBaseParam;
    redirectJSP = redirectJSPParam;

    if ( /* not localhost */ -1 == hostName.indexOf("localhost") &&
         /* not internal  */ -1 == hostName.indexOf("neo.ondemand.com") ) {
      this.artifactServer = new MavenCentral();
    } else {
      this.artifactServer = new Nexus();
    }
  }

  function Nexus() {
    this.title      = "nexus";
    this.URL        = nexusBase;

    this.resolveURL = function(gap, repository) {
      return this.URL  + "/service/local/artifact/maven/resolve?" +
                      "g=" + gap.group     +
                     "&a=" + gap.artifact  +
                     "&v=" + "LATEST"      +
                     "&p=" + gap.packaging +
                     "&r=" + repository ;
    };

    this.buildContentURL = function(gap, repository, version) {
      return this.URL + "/service/local/artifact/maven/content?" +
                      "g=" + gap.group     +
                     "&a=" + gap.artifact  +
                     "&v=" + version       +
                     "&p=" + gap.packaging +
                     "&r=" + repository;
    };

    this.browseURL    =  function(gap) {
      return nexusBase + "/index.html#nexus-search;gav~"+gap.group+"~"+gap.artifact+"~~~";
    };

    this.browseTarget = "internalNexus";

    this.parseVersion = function(xmlResponse) {
      var $versionNode = $(xmlResponse).find( "version" );
      if ($versionNode.length == 0) {
          return undefined;
      }
      return $versionNode.text();
    };

    this.ajax = function(gap, repository) {
      return $.ajax( {
        cache    : false,
        dataType : "xml",
        url      : redirectJSP+"?url=" + encodeURIComponent(this.resolveURL(gap, repository))
      });
    };

    return this;
  }

  function MavenCentral() {
    this.gap        = {group:"", artifact:"", packaging:""};
    this.repository = "";
    this.title      = "maven central";
    this.URL        = "http://search.maven.org";

    this.resolveURL = function(gap, repository) {
      return this.URL + "/solrsearch/select?" +
                  "q="    + ("g:%22"+gap.group+"%22+AND+a:%22"+gap.artifact+"%22") +
                 "&core=" + "gav" +
                 "&rows=" + "2"   +
                 "&wt="   + "json";
    };

    this.buildContentURL = function(gap, repository, version) {
      return this.URL + "/remotecontent?" +
                          "filepath=" + (gap.group.replace(/\./gi, '/') + '/' +
                                         gap.artifact                   + '/' +
                                         version                        + '/' +
                                         gap.artifact + "-" + version + '.' + gap.packaging);
    }

    this.browseURL    =  function(gap) {
      return this.URL + "/#search%7Cga%7C1%7Cg%3A%22"+gap.group+"%22%20AND%20a%3A%22"+gap.artifact+"%22";
    };

    this.browseTarget = "mavenCentral";

    this.parseVersion = function(jsonResponse) {
      if (!jsonResponse.response.docs.length) {
          return undefined;
      }
      return jsonResponse.response.docs[0].v;
    }

    this.ajax = function(gap, repository) {
      return $.ajax( {
        cache    : false,
        dataType : "json",
        url      : redirectJSP+"?url=" + encodeURIComponent(this.resolveURL(gap, repository))
      });
    };

    return this;
  }

  this.getIt = function(gap, repository, before, callback, after) {

    before();

    var artifactPromise = this.artifactServer.ajax(gap, repository);

    artifactPromise.done(function(response) {

      var version = artifactServer.parseVersion(response);
      var buildContentURL = undefined;
      if (typeof version !== "undefined") {
        buildContentURL = artifactServer.buildContentURL(gap, repository, version);
      }

      callback({
        status: (typeof version !== "undefined" && typeof buildContentURL !== "undefined"),
        version : version,
        buildContentURL : buildContentURL,
        browseURL : artifactServer.browseURL(gap),
        browseTarget : artifactServer.browseTarget
      });
    });

    artifactPromise.fail(function(  jqXHR, textStatus, errorThrown ) {
      callback({
        status: false,
        version : undefined,
        buildContentURL : undefined,
        browseURL : artifactServer.browseURL(gap),
        browseTarget : artifactServer.browseTarget
      });
    });

    artifactPromise.always(function() {
      after();
    });

    return;
  }

  return this;

})();