<%@page import="org.webjars.WebJarAssetLocator"
%><%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="t" tagdir="/WEB-INF/tags"
%><%!

WebJarAssetLocator  LOCATOR                      = new WebJarAssetLocator();
int                 META_INF_RESOUCE_PATH_LENGTH = "META-INF/resources/".length();

%><%

request.setAttribute("bootstrap_switch_css", LOCATOR.getFullPath("css/bootstrap3/bootstrap-switch.css").substring(META_INF_RESOUCE_PATH_LENGTH) );
request.setAttribute("bootstrap_switch_js",  LOCATOR.getFullPath("js/bootstrap-switch.js"             ).substring(META_INF_RESOUCE_PATH_LENGTH) );

%><t:layout module="geppaequo" jsmodules="moment">

<link rel="stylesheet" type="text/css" href="<c:url value='/${bootstrap_switch_css}' />" />

<h1 style="display:inline-block;">
  <span style="float:left; margin: 0 30px 30px 0;">
    <img style="float:left;" src="../assets/images/alphabet/051-16th-Century-letter-g-q85-187x200.jpg"/>
  </span>
  <span style="margin-left:-30px;">eppaequo Configuration</span>
</h1>

<form class="form-horizontal" role="form" style="background-color:#fafafa; padding: 10px 10px 0 10px; border: 1px solid #f0f0f0;">
  <span class="form-group">
    <label for="Title" class="col-sm-2 control-label">title</label>
    <span class="col-sm-4">
        <input type="text" class="form-control" id="Title" placeholder="title" disabled >
    </span>
  </span>
  <span class="form-group">
    <label for="DynamicHTML" class="col-sm-2 control-label">embedded header &amp; footer</label>

    <span class="col-sm-4">
        <input id="DynamicHTML"
               type="checkbox"
               data-label-text="h&amp;f"
               data-on-text="<i class='fa fa-check'></i>"
               data-off-text="<i class='fa fa-times'></i>">
    </span>
  </span>
  <span class="form-group">
    <label for="ShowGithubRibbon" class="col-sm-2 control-label">show github ribbon</label>

    <span class="col-sm-4">
        <input id="ShowGithubRibbon"
               type="checkbox"
               data-label-text="github"
               data-on-text="<i class='fa fa-check'></i>"
               data-off-text="<i class='fa fa-times'></i>">
    </span>
  </span>
</form>

<h2>Modules</h2>

<c:forEach var="entry" items="#{applicationScope.geppaequo_configMap}">
  <hr/>
  <h3><c:out value="${entry.key}"/></h3>
  <p>
    <strong>git:</strong>
    <a href="${applicationScope.geppaequo.gitURL}/${entry.key}/commit/${entry.value.gitRepositoryState.commitId}">
      <c:out value="${entry.value.gitRepositoryState.commitIdAbbrev}"/>
    </a>
    <span>&ldquo;<em><c:out value="${entry.value.gitRepositoryState.commitMessageShort}"/></em>&rdquo;</span>
  </p>
  <a href="<c:url value='/wizardry/.${entry.key}/application.conf'/>"><span>system properties</span></a>
  |
  <a class="applicationConfig" id="${entry.key}" href="<c:url value='/stnemucod/document/.${entry.key}/application.conf'/>"><span style="visibility: hidden;">application properties</span></a>
  <button id="${entry.key}_reload" type="button" class="btn btn-default">
    <span>reload <img id="ajaxLoading_${entry.key}_reload" src="<c:url value='/assets/images/animated_orange_refresh_22.png'/>"></span>
  </button>
  <button id="${entry.key}_save" type="button" class="btn btn-default">
    <span>save <img id="ajaxLoading_${entry.key}_save" src="<c:url value='/assets/images/animated_orange_refresh_22.png'/>"></span>
  </button>
  <div id="messages_${entry.key}"></div>
  <div  id="alert_${entry.key}" class="alert alert-dismissable" style="display:none; ">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  </div>
</c:forEach>

<div>&nbsp;</div>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='/assets/scripts/jolokia/jolokia-min.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/assets/scripts/jolokia/jolokia-simple-min.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/${bootstrap_switch_js}'    />" ></script>

<script type="text/javascript">

$(document).ready(function() {


  var JolokiaHelper = function (jolokiaResource, configName) {

    var _this_ = {};

    var j4p  = new Jolokia(jolokiaResource);

    var mbean = configName+":name=config";

    _this_.bindCheckboxes = function(elements) {
      elements.each( function(index, el) {
        var ID = $(el).attr('id');

        if (ID) {
          $(el).bootstrapSwitch();

          $(el).on('switchChange.bootstrapSwitch', function(e, state) {
              j4p.setAttribute( mbean, ID, state);
          });

          $(el).bootstrapSwitch('state', j4p.getAttribute( mbean, ID));
        }
      });
    };

    _this_.bindTexts = function(elements) {
        elements.each( function(index, el) {
          var ID = $(el).attr('id');
          if (ID) {
              $(el).attr('value', j4p.getAttribute( mbean, ID ));
          }
        });
    };

    _this_.reload = function() {
      $('#ajaxLoading_'+configName+"_reload").attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.gif'/>" });
      j4p.execute( mbean, "Configuration.reload", {
          success: function(value) {
              if (value) {
                console.log(JSON.stringify(value));
              }
              displayMessage("success", configName, "reloaded!")
              $('#ajaxLoading_'+configName+"_reload").attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.png'/>" });
          },
          error: function(response) {
              if (response.error) {
                 console.log(response.error);
              }
              displayMessage("danger", configName, response.error)
              $('#ajaxLoading_'+configName+"_reload").attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.png'/>" });
          }

       });
    };

    _this_.save = function() {
      $('#ajaxLoading_'+configName+"_save").attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.gif'/>" });
      j4p.execute( mbean, "Configuration.Application.save", {
          success: function(value) {
              console.log(JSON.stringify(value));
              displayMessage("success", configName, "saved!")
              $('#ajaxLoading_'+configName+"_save").attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.png'/>" });
          },
          error: function(response) {
              console.log();
              displayMessage("danger", configName, response.error)
              $('#ajaxLoading_'+configName+"_save").attr({src :"<c:url value='/assets/images/animated_orange_refresh_22.png'/>" });
          }
       });
    };

    function displayMessage(alertClass, strong, message) {
        var now = moment().format('MMMM Do YYYY, h:mm:ss a');
        $("#messages_"+configName).empty();
        $("#alert_"+configName).clone()
                   .addClass("alert-"+alertClass)
                   .css({display:"visible"})
                   .append("<small>"+now+"</small>&nbsp;|&nbsp;<strong>"+strong+"</strong> "+message)
                   .appendTo( "#messages_"+configName );
    }

    $("button#"+configName+"_reload").click(function( event ) {
      _this_.reload();
      // window.log(configName+" reloaded!");
      event.preventDefault();
    });

    $("button#"+configName+"_save").click(function( event ) {
      _this_.save();
      // window.log(configName+" saved!");
      event.preventDefault();
    });

    return _this_;
  };

var helpers = [];
<c:forEach var="entry" items="#{applicationScope.geppaequo_configMap}">
  var helper = new JolokiaHelper("<c:url value='/jolokia' />", "${entry.key}");
  helpers.push(helper);
  <c:if test="${entry.key eq 'geppaequo'}">
    helper.bindCheckboxes($('#DynamicHTML'));
    helper.bindCheckboxes($('#ShowGithubRibbon'));
    helper.bindTexts($('#Title'));
  </c:if>
</c:forEach>


  $(".applicationConfig").each(function(propertyName, valueOfProperty ) {
    var $span = $(this).children("span");

    $.ajax({
      type: "HEAD",
      async: true,
      url: valueOfProperty
    }).done  (function() {
    }).fail  (function() {
      $span.css({"text-decoration": "line-through"}).unwrap();
    }).always(function() {
      $span.css({visibility : "inherit"});
    });

  });

});

</script>
