<%@page contentType="text/html" pageEncoding="UTF-8"
%><%@ page import="java.security.Principal,org.apache.catalina.realm.GenericPrincipal" 
%><%@ taglib prefix="t" tagdir="/WEB-INF/tags"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><t:layout module="geppaequo">

<style>
th {
vertical-align: top;
}
</style>

  <h1>${pageContext.request.remoteUser}</h1>

  <table>
    <tr>
      <th>id</th>
      <td><span>${requestScope.userInfo.id}</span></td>
    </tr>
    <tr>
      <th>firstname</th>
      <td><span>${requestScope.userInfo.firstname}</span>
    <tr>
      <th>lastname</th>
      <td><span>${requestScope.userInfo.lastname}</span></td>
    </tr>
    <tr>
      <th>email</th>
      <td><span style="background:#eeeeee;">
        <c:if test="${empty requestScope.userInfo.email}">
          <img src="<c:url value='/assets/images/1x1.png'/>">
        </c:if>
        <c:if test="${not empty requestScope.userInfo.email}">
          <img src="<c:url value='/images/mail?amp;fontname=Monospaced&amp;fontstyle=2&amp;fontsize=20'/>">
        </c:if>
      </span></td>
    </tr>
    <tr>
      <th>roles</th>
      <td><span id="roles"></span></td>
    </tr>
  </table>

  <c:if test="${pageContext.request.isUserInRole('wizard') || pageContext.request.isUserInRole('LOCAL')}">
    <h3>You are a wizard</h3>
    <span style="background:#eeeeee;">
      <img src="<c:url value='/images/mail?test=true&amp;fontname=Monospaced&amp;fontstyle=2&amp;fontsize=20'/>"> <!-- &amp;border=true&amp;margin=32 -->
    <span>
  </c:if>

</t:layout>

<script type="text/javascript">
  $(document).ready(function(){

	var roles = [
<%
        try {
            final Principal userPrincipal = request.getUserPrincipal();
			if (userPrincipal != null && userPrincipal instanceof GenericPrincipal) {
				GenericPrincipal genericPrincipal = (GenericPrincipal) userPrincipal;
				final String[] roles = genericPrincipal.getRoles();
				if (userPrincipal != null) {
					int index = 0;
					for (String role : roles) {
						if (index > 0) {
							out.print(", ");
						}
						out.print("'");
						out.print(role.replace("\\", "\\\\"));
						out.print("'");
						index++;
					}
				}
			}
        } catch (UnsupportedOperationException uop) {
			out.print("'");
			out.print(uop.getClass().getSimpleName());
			out.print(": ");
			out.print(uop.getMessage());
			out.print("'");
        }		
%>	               
	  ];
	  
	  _.each(roles, function(element, index, list) {
		  $("#roles").append($("<div/>", {text: element }));
	  });

  });
</script>
