/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.geppaequo.config;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.aequologica.neo.geppaequo.config.AbstractConfig;
import net.aequologica.neo.geppaequo.config.Config;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConfigRegistry {
    CONFIG_REGISTRY;

    private final Logger log = LoggerFactory.getLogger(ConfigRegistry.class);
    final String DEFAULT_PREFIX = "/META-INF/resources/wizardry";
    private final Map<Class<? extends AbstractConfig>, AbstractConfig> map = new HashMap<Class<? extends AbstractConfig>, AbstractConfig>();
    private final Map<String, AbstractConfig> map2 = new HashMap<String, AbstractConfig>();
    private final String[] packages;
    private final DateTimeFormatter dateTimeFormatter;
    private final String splitter = ".";

    private ConfigRegistry() {
        String DEFAULT_PACKAGE = Stream.of(ConfigRegistry.class.getPackage().getName().split("\\.")).limit(3L).collect(Collectors.joining("."));
        this.packages = new String[]{DEFAULT_PACKAGE};
        this.dateTimeFormatter = ISODateTimeFormat.dateTime();
        this.scanConfigs();
    }

    public void registerConfig(AbstractConfig instance) {
        this.map.put(instance.getClass(), instance);
        this.map2.put(instance.getMetadata().getName(), instance);
    }

    public void unregisterConfig(Class<? extends AbstractConfig> clazz) {
        AbstractConfig removed = this.map.remove(clazz);
        this.map2.remove(removed.getMetadata().getName());
    }

    public <T> T getConfig(Class<T> clazz) {
        return clazz.cast(this.map.get(clazz));
    }

    public AbstractConfig getConfig(String name) {
        return this.map2.get(name);
    }

    public Map<String, AbstractConfig> getConfigMap() {
        return Collections.unmodifiableMap(this.map2);
    }

    public Set<AbstractConfig> getConfigs() {
        return Collections.unmodifiableSet(new HashSet<AbstractConfig>(this.map.values()));
    }

    public Set<String> getConfigNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (AbstractConfig config : this.map.values()) {
            names.add(config.getMetadata().getName());
        }
        return Collections.unmodifiableSortedSet(names);
    }

    void clearConfigs() {
        this.map.clear();
        this.map2.clear();
    }

    void scanConfigs() {
        this.scanConfigs(this.packages);
    }

    private DateTime safeToDate(Object o) {
        return o == null ? null : this.dateTimeFormatter.parseDateTime(o.toString());
    }

    public void scanConfigs(String[] packages) {
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)prefix, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true), new TypeAnnotationsScanner()}).filterInputsBy((Predicate)new FilterBuilder().include(".*\\.class")));
            Set classes = reflections.getTypesAnnotatedWith(Config.class);
            this.log.debug("Found {} classe(s) annotated with {} -> {}", new Object[]{classes.size(), Config.class.getName(), classes});
            for (Class clazz : classes) {
                Config configAnnotation = clazz.getAnnotation(Config.class);
                if (configAnnotation == null) continue;
                String buildTime = this.getBuildTimeFromManifestInSameJar(clazz);
                Package package_ = clazz.getPackage();
                String g = "net.aequologica.neo";
                String a = package_.getImplementationTitle();
                String v = package_.getImplementationVersion();
                String name = configAnnotation.name();
                int modifiers = clazz.getModifiers();
                if (Modifier.isAbstract(modifiers)) {
                    this.log.debug("{} is abstract. ignored.", (Object)clazz.getName());
                    continue;
                }
                if (!Modifier.isPublic(modifiers)) {
                    this.log.debug("{} is not public. ignored.", (Object)clazz.getName());
                    continue;
                }
                AbstractConfig config = null;
                try {
                    config = (AbstractConfig)clazz.newInstance();
                    config.setBuildTime(this.safeToDate(buildTime));
                    config.setGav(new AbstractConfig.GAV("net.aequologica.neo", a, v));
                    this.registerConfig(config);
                }
                catch (Exception e) {
                    this.log.error("instantiation of class {} failed with exception: {}", (Object)clazz, (Object)e);
                    continue;
                }
                this.log.info("Config created [\"{}\" -> {} -> {}]", new Object[]{name, clazz, config});
            }
            ++n2;
        }
    }

    private String getBuildTimeFromManifestInSameJar(Class<?> clazz) {
        URL resource;
        block16: {
            block15: {
                if (clazz != null) break block15;
                return null;
            }
            resource = clazz.getResource(String.valueOf(clazz.getSimpleName()) + ".class");
            if (resource != null) break block16;
            return null;
        }
        try {
            int webInfIndex;
            String resourceAsString = resource.toString();
            if (resourceAsString.startsWith("jar:")) {
                return this.getBuildTimeFromJarManifest(resource);
            }
            if (resourceAsString.startsWith("file:") && (webInfIndex = resourceAsString.indexOf("WEB-INF")) != -1) {
                String manifestResource = String.valueOf(resourceAsString.substring(0, webInfIndex)) + "META-INF/MANIFEST.MF";
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream stream = new URL(manifestResource).openStream();){
                    Manifest manifest = new Manifest(stream);
                    Attributes attributes = manifest.getMainAttributes();
                    return attributes.getValue("Build-Time");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            this.log.error("ignored exception", (Throwable)e);
        }
        return null;
    }

    private String getBuildTimeFromJarManifest(URL url) throws IOException {
        try {
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            Manifest manifest = jarConnection.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue("Build-Time");
        }
        catch (NullPointerException npe) {
            this.log.error("ignored null pointer exception in getBuildTimeFromJarManifest", (Throwable)npe);
            return "";
        }
    }
}

