/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.geppaequo.config;

import com.google.common.base.Charsets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import net.aequologica.neo.geppaequo.cmis.ECMHelper;
import net.aequologica.neo.geppaequo.cmis.impl.ECMHelperFactory;
import net.aequologica.neo.geppaequo.config.ContextProvider;
import net.aequologica.neo.geppaequo.document.DocumentHelper;
import net.aequologica.neo.geppaequo.jndi.JndiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class ConfigManager {
    static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private final String applicationName;
    private final ContextProvider contextProvider;
    Config config;
    private final ConfigSource system = new ConfigSourceSystem();
    private final ConfigSource user = new ConfigSourceUser();
    private final ConfigSource application = new ConfigSourceApplication();
    private static final ConfigRenderOptions configRenderOptions = ConfigRenderOptions.defaults().setComments(true).setFormatted(true).setJson(false).setOriginComments(false);
    private static final DateFormat FORMAT = new SimpleDateFormat("-yyyyMMdd.hhmmss");

    ConfigManager(String applicationName, ContextProvider contextProvider) {
        this.applicationName = applicationName;
        this.contextProvider = contextProvider;
    }

    public void set(String originalKey, Object object) {
        String key = String.valueOf(this.applicationName) + "." + originalKey;
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            this.application.setConfig(this.application.getConfig().withoutPath(key));
        } else {
            ConfigValue value = ConfigValueFactory.fromAnyRef((Object)object, (String)"modified at runtime ");
            this.application.setConfig(this.application.getConfig().withValue(key, value));
        }
        this.config = this.application.getConfig().withFallback((ConfigMergeable)this.user.getConfig()).withFallback((ConfigMergeable)this.system.getConfig());
    }

    void resolveConfigURIs() throws IOException {
        this.system.resolveLocation();
        this.user.resolveLocation();
        this.application.resolveLocation();
    }

    void loadConfigs() throws IOException {
        this.application.loadConfig();
        this.user.loadConfig();
        this.system.loadConfig();
        this.config = this.application.getConfig().withFallback((ConfigMergeable)this.user.getConfig()).withFallback((ConfigMergeable)this.system.getConfig());
        ConfigManager.dump2debugLog("MERGED", this.config);
    }

    @Managed(description="system configuration")
    @Nested
    public ConfigSource getSystem() {
        return this.system;
    }

    @Managed(description="user configuration")
    @Nested
    public ConfigSource getUser() {
        return this.user;
    }

    @Managed(description="application configuration")
    @Nested
    public ConfigSource getApplication() {
        return this.application;
    }

    @Managed(description="reload and merge all configurations (this will undo any unsaved change)")
    public void reload() throws IOException {
        this.resolveConfigURIs();
        this.loadConfigs();
    }

    public String toString() {
        return this.config.origin().toString();
    }

    static void dumpConfig(String name, Config config, PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("writer argument cannot be null");
        }
        printWriter.println();
        printWriter.println("^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^  ^");
        printWriter.println(String.valueOf(name) + " " + config.root().origin());
        printWriter.println(config.root().render(configRenderOptions));
        printWriter.flush();
    }

    static void dump2debugLog(String name, Config config) {
        if (log.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            Throwable throwable = null;
            Object var4_5 = null;
            try (PrintWriter pw = new PrintWriter(sw);){
                ConfigManager.dumpConfig(name, config, pw);
                log.debug(sw.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private String getFilePathFromJNDI() {
        String ret;
        block7: {
            ret = null;
            String contextString = null;
            Context ctx = this.contextProvider.getNamingContext();
            if (ctx == null) {
                String name = "java:comp/env";
                try {
                    ctx = new JndiUtil("java:comp/env").getContext();
                    contextString = "java:comp/env";
                }
                catch (NamingException e) {
                    log.warn("'java:comp/env' naming context not found. Exception is [" + e.getMessage() + "]");
                    return null;
                }
            }
            String lookupName = "/." + this.applicationName + "/application.conf";
            try {
                Object obj = ctx.lookup(lookupName);
                if (obj instanceof File) {
                    ret = ((File)obj).getAbsolutePath();
                    break block7;
                }
                if (obj.toString().length() > 0) {
                    ret = obj.toString();
                    break block7;
                }
                log.warn("Name '{}' in JNDI context '{}' must be of type File or String", (Object)lookupName, contextString != null ? contextString : ctx);
                return null;
            }
            catch (Exception ignored) {
                log.warn("Name '{}' not found in JNDI context '{}'.", (Object)lookupName, contextString != null ? contextString : ctx);
                return null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTimeStamp() {
        DateFormat dateFormat = FORMAT;
        synchronized (dateFormat) {
            String timeStamp = FORMAT.format(new Date());
            return timeStamp;
        }
    }

    private static String reader2String(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return stringBuilder.toString();
    }

    private static URI resolveLocationClasspath(String string) {
        URI uri = null;
        try {
            URL url = ConfigManager.class.getResource(string);
            if (url == null) {
                log.warn("'{}' not found on the classpath.", (Object)string);
            } else {
                String urlNoSpaces = url.toExternalForm().replace(" ", "%20");
                uri = new URI(urlNoSpaces);
            }
        }
        catch (Exception e) {
            log.warn("'{}' not found on the class path, or cannot convert classpath to a valid URI : {}", (Object)string, (Object)e);
        }
        return uri;
    }

    public abstract class AbstractConfigSource
    implements ConfigSource {
        protected final String name;
        protected URI uri;
        protected Config config = ConfigFactory.empty();

        protected AbstractConfigSource(String name) {
            this.name = name;
        }

        @Override
        @Managed
        public URI getLocation() {
            return this.uri;
        }

        @Override
        public Config getConfig() {
            return this.config;
        }

        @Override
        public void setConfig(Config config) {
            this.config = config;
        }

        @Override
        public abstract void resolveLocation();

        @Override
        public String save() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void loadConfig() throws IOException {
            if (this.uri != null) {
                Config localConfig = ConfigFactory.empty();
                this.config = localConfig = ConfigFactory.parseURL((URL)this.uri.toURL(), (ConfigParseOptions)ConfigParseOptions.defaults().setOriginDescription(this.uri.toString()));
                ConfigManager.dump2debugLog(this.name, this.config);
            } else {
                log.debug("nothing to load, uri is null for {}", (Object)this.getClass().getSimpleName());
            }
        }

        @Override
        public String toString() {
            return String.valueOf(this.name) + " " + this.config.origin().toString();
        }
    }

    static interface ConfigSource {
        public URI getLocation();

        public Config getConfig();

        public void setConfig(Config var1);

        public void resolveLocation();

        public void loadConfig() throws IOException;

        public String save() throws IOException;

        public String toString();
    }

    public final class ConfigSourceApplication
    extends AbstractConfigSource {
        protected ConfigSourceApplication() {
            super("APPLICATION");
        }

        @Override
        public void resolveLocation() {
            String path;
            this.uri = null;
            if (ECMHelperFactory.ECMHELPERFACTORY.getEcmService() != null) {
                path = "/." + ConfigManager.this.applicationName + "/application.conf";
                try {
                    this.uri = new URI("cmis", path, null);
                }
                catch (URISyntaxException ignored) {
                    log.warn("'cmis:{}' is not a valid URI. Exception: {}", (Object)path, (Object)ignored.getMessage());
                }
            }
            if (this.uri == null) {
                path = ConfigManager.this.getFilePathFromJNDI();
                if (path != null && path.length() > 0) {
                    File file = new File(path);
                    this.uri = file.toURI();
                } else {
                    Path path2 = Paths.get("/." + ConfigManager.this.applicationName, "application.conf");
                    try {
                        List documentPaths2 = DocumentHelper.getDocumentPaths((Path)path2);
                        if (documentPaths2.size() > 0) {
                            this.uri = new File((String)documentPaths2.get(0)).toURI();
                        }
                    }
                    catch (IOException ignored2) {
                        log.warn("ignoring {} raised by DocumentHelper.getDocumentPaths(\"{}\"): {}", new Object[]{ignored2.getClass().getName(), path2, ignored2.getMessage()});
                    }
                }
            }
        }

        @Override
        public void loadConfig() throws IOException {
            this.config = ConfigFactory.empty();
            if (this.uri != null && this.uri.getScheme() != null) {
                String applicationConfigAsAString = null;
                if (this.uri.getScheme().equals("cmis")) {
                    try {
                        Throwable throwable = null;
                        Object var3_6 = null;
                        try (ECMHelper ecmHelper = ECMHelperFactory.ECMHELPERFACTORY.getEcmHelper();){
                            applicationConfigAsAString = ecmHelper.readUTF8Document(Paths.get(this.uri.getPath(), new String[0]));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        log.warn(e.getMessage());
                    }
                } else if (this.uri.getScheme().equals("file")) {
                    File file = new File(this.uri.getPath());
                    if (!file.exists()) {
                        log.warn("file '{}' not found.", (Object)file.getAbsolutePath());
                    } else {
                        try {
                            Throwable throwable = null;
                            Object var4_12 = null;
                            try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8.name());){
                                applicationConfigAsAString = ConfigManager.reader2String(fileReader);
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ignored) {
                            log.warn("error reading '{}': {}", (Object)this.uri, (Object)ignored.getMessage());
                            applicationConfigAsAString = null;
                        }
                    }
                }
                if (applicationConfigAsAString != null) {
                    try {
                        this.config = ConfigFactory.parseString(applicationConfigAsAString, (ConfigParseOptions)ConfigParseOptions.defaults().setOriginDescription(this.uri.toString()));
                    }
                    catch (Exception ignored) {
                        log.error("[" + this.name + "] error loading configuration from " + this.uri.toString(), (Throwable)ignored);
                    }
                    ConfigManager.dump2debugLog(this.name, this.config);
                }
            }
        }

        @Override
        @Managed(description="save application configuration")
        public String save() throws IOException {
            String ret = this.save(null);
            log.info(ret);
            return ret;
        }

        String save(File fileArgument) throws IOException {
            String standardName;
            if (this.config == null) {
                return "Current application config is null. This is a bug. Contact the administrator.";
            }
            if (this.uri != null && this.uri.getScheme() != null && this.uri.getScheme().equals("cmis") && this.uri.getPath() != null) {
                Path path = Paths.get(this.uri.getPath(), new String[0]);
                Throwable throwable = null;
                Object var4_7 = null;
                try (ECMHelper ecmHelper = ECMHelperFactory.ECMHELPERFACTORY.getEcmHelper();){
                    String configAsAString = this.config.root().render(configRenderOptions);
                    ecmHelper.createOrUpdateUTF8Document(path, configAsAString);
                    log.debug("\n{}\n saved @ {}", (Object)configAsAString, (Object)path);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return "New configuration saved to \n\t" + path;
            }
            if (fileArgument != null) {
                standardName = fileArgument.getCanonicalPath();
            } else {
                if (this.uri == null || this.uri.getScheme() == null || !this.uri.getScheme().equals("file")) {
                    throw new IOException("uri is null, or uri.scheme is null, or uri.scheme is not 'file' : nowhere to save ...");
                }
                standardName = this.uri.getPath();
            }
            int lastDot = standardName.lastIndexOf(46);
            String timestampedName = lastDot != -1 ? String.valueOf(standardName.substring(0, lastDot)) + ConfigManager.getTimeStamp() + standardName.substring(lastDot) : String.valueOf(standardName) + ConfigManager.getTimeStamp();
            File backup = new File(timestampedName);
            new File(standardName).renameTo(backup);
            File newConfig = new File(standardName);
            Throwable throwable = null;
            Object var8_16 = null;
            try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(newConfig), Charsets.UTF_8.name());){
                String configAsAString = this.config.root().render(configRenderOptions);
                fileWriter.write(configAsAString);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            return "New configuration saved to \n\t" + newConfig.getCanonicalPath() + "\nPrevious configuration backuped to \n\t" + backup.getCanonicalPath();
        }
    }

    public final class ConfigSourceSystem
    extends AbstractConfigSource {
        protected ConfigSourceSystem() {
            super("SYSTEM");
        }

        @Override
        public void resolveLocation() {
            this.uri = null;
            String DEFAULT_PREFIX = "/META-INF/resources/wizardry";
            String start = "/META-INF/resources/wizardry/." + ConfigManager.this.applicationName + "/";
            String uriAsStringForTest = String.valueOf(start) + "application-test.conf";
            String uriAsString = String.valueOf(start) + "application.conf";
            this.uri = ConfigManager.resolveLocationClasspath(uriAsStringForTest);
            if (this.uri == null) {
                this.uri = ConfigManager.resolveLocationClasspath(uriAsString);
            }
        }
    }

    public final class ConfigSourceUser
    extends AbstractConfigSource {
        protected ConfigSourceUser() {
            super("USER");
        }

        @Override
        public void resolveLocation() {
            this.uri = null;
            File userHome = new File(System.getProperty("user.home"));
            File userAppConfigDir = new File(userHome, "." + ConfigManager.this.applicationName);
            File userAppConfigFile = new File(userAppConfigDir, "application.conf");
            if (userAppConfigFile.exists()) {
                this.uri = userAppConfigFile.toURI();
            } else {
                log.warn("File '" + userAppConfigFile.getAbsolutePath() + "' does not exist.");
            }
        }
    }
}

