/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.geppaequo.config;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.aequologica.neo.geppaequo.Constants;
import net.aequologica.neo.geppaequo.config.AbstractConfig;
import net.aequologica.neo.geppaequo.config.Config;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConfigRegistry {
    CONFIG_REGISTRY;

    private final Logger log = LoggerFactory.getLogger(ConfigRegistry.class);
    final String DEFAULT_PREFIX = "/META-INF/resources/wizardry";
    private final Map<Class<? extends AbstractConfig>, AbstractConfig> map = new HashMap<Class<? extends AbstractConfig>, AbstractConfig>();
    private final Map<String, AbstractConfig> map2 = new HashMap<String, AbstractConfig>();
    private final String[] packages;

    private ConfigRegistry() {
        String DEFAULT_PACKAGE = Constants.joinTheThreeLittlePigs((String[])Constants.splitTheThreeLittlePigs((String)ConfigRegistry.class.getName()), (char)'.');
        this.packages = new String[]{DEFAULT_PACKAGE};
        this.scanConfigs();
    }

    public void registerConfig(AbstractConfig instance) {
        this.map.put(instance.getClass(), instance);
        this.map2.put(instance.getMetadata().getName(), instance);
    }

    public void unregisterConfig(Class<? extends AbstractConfig> clazz) {
        AbstractConfig removed = this.map.remove(clazz);
        this.map2.remove(removed.getMetadata().getName());
    }

    public <T> T getConfig(Class<T> clazz) {
        return clazz.cast(this.map.get(clazz));
    }

    public AbstractConfig getConfig(String name) {
        return this.map2.get(name);
    }

    public Map<String, AbstractConfig> getConfigMap() {
        return Collections.unmodifiableMap(this.map2);
    }

    public Set<AbstractConfig> getConfigs() {
        return Collections.unmodifiableSet(new HashSet<AbstractConfig>(this.map.values()));
    }

    public Set<String> getConfigNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (AbstractConfig config : this.map.values()) {
            names.add(config.getMetadata().getName());
        }
        return Collections.unmodifiableSortedSet(names);
    }

    public void clearConfigs() {
        this.map.clear();
        this.map2.clear();
    }

    public void scanConfigs() {
        this.scanConfigs(this.packages);
    }

    public void scanConfigs(String[] packages) {
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)prefix, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true), new TypeAnnotationsScanner()}));
            Set classes = reflections.getTypesAnnotatedWith(Config.class);
            this.log.debug("Found {} classe(s) annotated with {} -> {}", new Object[]{classes.size(), Config.class.getName(), classes});
            for (Class clazz : classes) {
                Config configAnnotation = clazz.getAnnotation(Config.class);
                String name = configAnnotation.name();
                int modifiers = clazz.getModifiers();
                if (Modifier.isAbstract(modifiers)) {
                    this.log.debug("{} is abstract. ignored.", (Object)clazz.getName());
                    continue;
                }
                if (!Modifier.isPublic(modifiers)) {
                    this.log.debug("{} is not public. ignored.", (Object)clazz.getName());
                    continue;
                }
                AbstractConfig config = null;
                try {
                    config = (AbstractConfig)clazz.newInstance();
                    this.registerConfig(config);
                }
                catch (Exception e) {
                    this.log.error("instantiation of class {} failed with exception: {}", (Object)clazz, (Object)e);
                    continue;
                }
                this.log.info("Config created [\"{}\" -> {} -> {}]", new Object[]{name, clazz, config});
            }
            ++n2;
        }
    }
}

