package net.aequologica.neo.geppaequo.config;

import static net.aequologica.neo.geppaequo.Constants.joinTheThreeLittlePigs;
import static net.aequologica.neo.geppaequo.Constants.splitTheThreeLittlePigs;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConfigRegistry {
    
    CONFIG_REGISTRY;
    
    private final Logger log = LoggerFactory.getLogger(ConfigRegistry.class);
    /*   */ final String DEFAULT_PREFIX  = "/META-INF/resources/wizardry";

    private final Map <Class<? extends AbstractConfig>, AbstractConfig> map;
	private final Map <String, AbstractConfig>                          map2;
	private final String[]                                              packages;

	ConfigRegistry() {
        map  = new HashMap<>();
        map2 = new HashMap<>();
        final String DEFAULT_PACKAGE =  joinTheThreeLittlePigs(splitTheThreeLittlePigs(ConfigRegistry.class.getName()), '.');
        packages = new String[] { DEFAULT_PACKAGE };
        
        scanConfigs();
    }

    public void registerConfig(AbstractConfig instance) {
        map.put(instance.getClass(), instance);
        map2.put(instance.getMetadata().getName(), instance);
    }

    public void unregisterConfig(Class<? extends AbstractConfig> clazz) {
        AbstractConfig removed = map.remove(clazz);
        map2.remove(removed.getMetadata().getName());
    }

    public <T> T getConfig(Class<T> clazz) {
        return clazz.cast(map.get(clazz));
    }

    public AbstractConfig getConfig(String name) {
        return map2.get(name);
    }

    public Map <String, AbstractConfig> getConfigMap() {
        return Collections.unmodifiableMap(map2);
    }

    public Set<AbstractConfig> getConfigs() {
        return Collections.unmodifiableSet(new HashSet<AbstractConfig>(map.values()));
    }

    public Set<String> getConfigNames() {
        TreeSet<String> names = new TreeSet<>();
        for (AbstractConfig config : map.values()) {
            names.add(config.getMetadata().getName());
        }
        return Collections.unmodifiableSortedSet(names);
    }

    public void clearConfigs() {
        map.clear();
        map2.clear();
    }

    public void scanConfigs() {
        scanConfigs(packages);
    }

    public void scanConfigs(String[] packages) {
        for (String prefix: packages) {

            Reflections reflections = new Reflections(
                    new ConfigurationBuilder()
                        .setUrls(ClasspathHelper.forPackage(prefix))
                        .setScanners(
                            new SubTypesScanner(true),
                            new TypeAnnotationsScanner()
                        )
                    );

            Set<Class<?>> classes = reflections.getTypesAnnotatedWith(Config.class);

            log.debug("Found {} classe(s) annotated with {} -> {}", classes.size(), Config.class.getName(), classes);

            for (Class<?> clazz : classes) {

                Config configAnnotation = clazz.getAnnotation(Config.class);

                String name = configAnnotation.name();

                int modifiers = clazz.getModifiers();

                if (Modifier.isAbstract( modifiers )) {
                    log.debug("{} is abstract. ignored.", clazz.getName());
                    continue;
                }
                if (!Modifier.isPublic( modifiers )) {
                    log.debug("{} is not public. ignored.", clazz.getName());
                    continue;
                }

                AbstractConfig config = null;
                try {
                    config = (AbstractConfig)clazz.newInstance(); 
                    registerConfig(config);
                } catch (Exception e) {
                    log.error("instantiation of class {} failed with exception: {}", clazz, e);
                    continue;
                }

                log.info("Config created [\"{}\" -> {} -> {}]", name, clazz, config);
            }
        }
    }

}
