/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.geppaequo.config;

import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.aequologica.neo.geppaequo.Constants;
import net.aequologica.neo.geppaequo.config.AbstractConfig;
import net.aequologica.neo.geppaequo.config.Config;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRegistry {
    private static final Logger log = LoggerFactory.getLogger(ConfigRegistry.class);
    static final String DEFAULT_PREFIX = "/META-INF/resources/wizardry";
    private static final String DEFAULT_PACKAGE = Constants.joinTheThreeLittlePigs((String[])Constants.splitTheThreeLittlePigs((String)ConfigRegistry.class.getName()), (char)'.');
    private static final Map<Class<? extends AbstractConfig>, AbstractConfig> map = new HashMap<Class<? extends AbstractConfig>, AbstractConfig>();
    private static final Map<String, AbstractConfig> map2 = new HashMap<String, AbstractConfig>();
    private static final String[] packages = new String[]{DEFAULT_PACKAGE};

    private ConfigRegistry() {
    }

    public static void registerConfig(AbstractConfig instance) {
        map.put(instance.getClass(), instance);
        map2.put(instance.getMetadata().getName(), instance);
    }

    public static void unregisterConfig(Class<? extends AbstractConfig> clazz) {
        AbstractConfig removed = map.remove(clazz);
        map2.remove(removed.getMetadata().getName());
    }

    public static <T> T getConfig(Class<T> clazz) {
        return clazz.cast(map.get(clazz));
    }

    public static AbstractConfig getConfig(String name) {
        return map2.get(name);
    }

    public static Map<String, AbstractConfig> getConfigMap() {
        return Collections.unmodifiableMap(map2);
    }

    public static Set<AbstractConfig> getConfigs() {
        return Collections.unmodifiableSet(new HashSet<AbstractConfig>(map.values()));
    }

    public static Set<String> getConfigNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (AbstractConfig config : map.values()) {
            names.add(config.getMetadata().getName());
        }
        return Collections.unmodifiableSortedSet(names);
    }

    public static void clearConfigs() {
        map.clear();
        map2.clear();
    }

    public static void scanConfigs() {
        for (String prefix : packages) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)prefix, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true), new TypeAnnotationsScanner()}));
            Set classes = reflections.getTypesAnnotatedWith(Config.class);
            log.debug("Found {} classe(s) annotated with {} -> {}", new Object[]{classes.size(), Config.class.getName(), classes});
            for (Class clazz : classes) {
                Config configAnnotation = clazz.getAnnotation(Config.class);
                String name = configAnnotation.name();
                int modifiers = clazz.getModifiers();
                if (Modifier.isAbstract(modifiers)) {
                    log.debug("{} is abstract. ignored.", (Object)clazz.getName());
                    continue;
                }
                if (!Modifier.isPublic(modifiers)) {
                    log.debug("{} is not public. ignored.", (Object)clazz.getName());
                    continue;
                }
                AbstractConfig config = null;
                try {
                    config = (AbstractConfig)clazz.newInstance();
                }
                catch (Exception e) {
                    log.error("instantiation of class {} failed with exception: {}", (Object)clazz, (Object)e);
                    continue;
                }
                log.info("Config created [\"{}\" -> {} -> {}]", new Object[]{name, clazz, config});
            }
        }
    }

    private static String[] getPrefixes(Properties properties, String default_prefix) {
        ArrayList prefixes = Lists.newArrayList();
        prefixes.add(default_prefix);
        return prefixes.toArray(new String[0]);
    }
}

