/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.geppaequo.config;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.naming.Context;
import net.aequologica.neo.geppaequo.config.Config;
import net.aequologica.neo.geppaequo.config.ConfigManager;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.config.ContextProvider;
import net.aequologica.neo.geppaequo.git.GitRepositoryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public abstract class AbstractConfig
implements ContextProvider {
    static final Logger log = LoggerFactory.getLogger(AbstractConfig.class);
    private final ConfigManager serializer;
    private final Metadata metadata;
    private GitRepositoryState gitRepositoryState = null;
    private com.typesafe.config.Config proxy;

    public AbstractConfig() throws IOException {
        Config configAnnotation = this.getClass().getAnnotation(Config.class);
        if (configAnnotation == null) {
            throw new RuntimeException("This class must be annotated with the '" + Config.class.getName() + "' annotation, with a not null, not empty, all-lowercase 'name' attribute.");
        }
        String name = configAnnotation.name();
        if (name == null || name.length() == 0 || !name.toLowerCase().equals(name)) {
            throw new RuntimeException(Config.class.getName() + ".name (\"" + name + "\") annotation attribute must be not null, not empty, and all lowercase.");
        }
        this.metadata = new Metadata(name);
        this.serializer = new ConfigManager(name, this);
        this.serializer.resolveConfigURIs();
        this.serializer.loadConfigs();
        ConfigRegistry.registerConfig(this);
    }

    @Override
    public Context getNamingContext() {
        return null;
    }

    @Managed
    @Nested
    public ConfigManager getConfiguration() {
        return this.serializer;
    }

    @Managed
    @Nested
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Managed(description="git info")
    @Nested
    public GitRepositoryState getGitRepositoryState() {
        return this.gitRepositoryState;
    }

    public void setGitRepositoryState(GitRepositoryState gitRepositoryState) {
        this.gitRepositoryState = gitRepositoryState;
    }

    protected String get(String key) {
        return this.getProxy().getString(key);
    }

    protected Integer getInt(String key) {
        return this.getProxy().getInt(key);
    }

    protected List<String> getStringList(String key) {
        return this.getProxy().getStringList(key);
    }

    protected void set(String key, Object value) {
        this.serializer.set(key, value);
    }

    public void reload() throws Exception {
        this.serializer.reload();
    }

    protected com.typesafe.config.Config getProxy() {
        if (this.proxy == null) {
            this.proxy = (com.typesafe.config.Config)Proxy.newProxyInstance(this.serializer.config.getClass().getClassLoader(), new Class[]{com.typesafe.config.Config.class}, (InvocationHandler)new ConfigProxy());
        }
        return this.proxy;
    }

    public class ConfigProxy
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object result;
            try {
                Object[] newArgs = Arrays.copyOf(args, args.length);
                int i = 0;
                for (Object object : args) {
                    if (object instanceof String) {
                        newArgs[i] = AbstractConfig.this.metadata.name + "." + (String)object;
                        break;
                    }
                    ++i;
                }
                result = m.invoke((Object)((AbstractConfig)AbstractConfig.this).serializer.config, newArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage(), e);
            }
            return result;
        }
    }

    public static class Metadata {
        private final String name;

        Metadata(String name) {
            this.name = name;
        }

        @Managed
        public String getName() {
            return this.name;
        }
    }
}

