package net.aequologica.neo.geppaequo.cdi.jaxrs;

import java.io.IOException;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import net.aequologica.neo.geppaequo.cdi.HelloWorld;

@Path("/v1")
public class Resource<T> {

    @Context
    ServletContext context;

    @Context
    HttpServletRequest request;

    @Inject
    HelloWorld helloWorld;

    public Resource() throws IOException {
        super();
    }

    
    
    // ping service
    @GET
    @Path("ping")
    @Produces(MediaType.TEXT_PLAIN)
    public String ping() {
        return helloWorld.getGreeting() + "\nrequest uri: " + request.getRequestURI() + "\nservlet version: " + context.getMajorVersion() + "." + context.getMinorVersion();
    }
}
