/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.util.Iterator;
import org.jboss.weld.context.AbstractManagedContext;
import org.jboss.weld.context.BoundContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BoundBeanStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class AbstractBoundContext<S>
extends AbstractManagedContext
implements BoundContext<S> {
    private final ThreadLocal<BoundBeanStore> beanStore = new ThreadLocal();

    public AbstractBoundContext(String contextId, boolean multithreaded) {
        super(contextId, multithreaded);
    }

    protected BoundBeanStore getBeanStore() {
        BoundBeanStore bbs = this.beanStore.get();
        if (bbs == null) {
            return new NullBoundBeanStore();
        }
        return bbs;
    }

    protected void setBeanStore(BoundBeanStore beanStore) {
        if (beanStore == null) {
            this.beanStore.remove();
        } else {
            this.beanStore.set(beanStore);
        }
    }

    public void cleanup() {
        super.cleanup();
        this.beanStore.remove();
    }

    public void activate() {
        super.activate();
        this.getBeanStore().attach();
    }

    public void deactivate() {
        this.getBeanStore().detach();
        super.deactivate();
    }

    public boolean dissociate(S storage) {
        if (this.getBeanStore() != null) {
            try {
                this.setBeanStore(null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cleanup();
            }
        }
        return false;
    }

    class NullBoundBeanStore
    implements BoundBeanStore {
        NullBoundBeanStore() {
        }

        public <T> ContextualInstance<T> remove(BeanIdentifier id) {
            return null;
        }

        public <T> void put(BeanIdentifier id, ContextualInstance<T> contextualInstance) {
        }

        public LockedBean lock(BeanIdentifier id) {
            return null;
        }

        public Iterator<BeanIdentifier> iterator() {
            return new Iterator<BeanIdentifier>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public BeanIdentifier next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }

        public <T> ContextualInstance<T> get(BeanIdentifier id) {
            return null;
        }

        public boolean contains(BeanIdentifier id) {
            return false;
        }

        public void clear() {
        }

        public boolean isAttached() {
            return false;
        }

        public boolean detach() {
            return false;
        }

        public boolean attach() {
            return false;
        }
    }
}

