/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.AbstractManagedContext;
import org.jboss.weld.context.BoundContext;
import org.jboss.weld.context.beanstore.BoundBeanStore;

public abstract class AbstractBoundContext<S>
extends AbstractManagedContext
implements BoundContext<S> {
    private final ThreadLocal<BoundBeanStore> beanStore = new ThreadLocal();

    public AbstractBoundContext(String contextId, boolean multithreaded) {
        super(contextId, multithreaded);
    }

    protected BoundBeanStore getBeanStore() {
        BoundBeanStore bbs = (BoundBeanStore)this.beanStore.get();
        if (bbs == null) {
            return new NullBoundBeanStore(this);
        }
        return bbs;
    }

    protected void setBeanStore(BoundBeanStore beanStore) {
        if (beanStore == null) {
            this.beanStore.remove();
        } else {
            this.beanStore.set(beanStore);
        }
    }

    public void cleanup() {
        super.cleanup();
        this.beanStore.remove();
    }

    public void activate() {
        super.activate();
        this.getBeanStore().attach();
    }

    public void deactivate() {
        this.getBeanStore().detach();
        super.deactivate();
    }

    public boolean dissociate(S storage) {
        if (this.getBeanStore() != null) {
            try {
                this.setBeanStore(null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cleanup();
            }
        }
        return false;
    }
}

