var parseGitUrl = function parse(input) {
  var ret = {
      url   : undefined,
      hash  : undefined,
      slug  : undefined,
      title : undefined,
      host  : undefined,
  }
  
  if (!input || !input.scm ) {
    return ret;
  }
  
  if (input.scm.substring(0,3) == "ssh") {
    input.scm = "https" + input.scm.substring(3);
  }
  
  if (input.scm.indexOf("@") != -1) {
    input.scm = input.scm .replace(/\/\/(.*)\@/gi, "//");
  }
  
  var p = new URL(input.scm);
  
  ret.slug = p.pathname.replace(/\.git$/gi, "").replace(/^\//gi, "");
  
  ret.host = p.hostname;

  if (input.commit) {
    if (input.scm.indexOf("//git.wdf.sap.corp")!= -1) {
      ret.url = p.protocol + "//" + p.hostname + ":8080/gitweb?p="+ ret.slug + ".git;a=commit;h=" + input.commit;
    } else {
      ret.url = p.protocol + "//" + p.hostname + (p.port?":" + p.port:"") + "/" + ret.slug + "/commit/" + input.commit;
    }
    
    ret.hash  = input.commit.substring(0,8);
  }
  
  ret.title = ret.slug + " @ " + p.hostname;

  return ret
};
