;(function(){

  /////////////////////////////////////////////////////////////////////////////
  // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
  function tryParseJSON(hypotheticalJSON){
    try {
        var o = JSON.parse(hypotheticalJSON);

        // Handle non-exception-throwing cases:
        // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
        // but... JSON.parse(null) returns 'null', and typeof null === "object", 
        // so we must check for that, too.
        if (o && typeof o === "object" && o !== null) {
            return o;
        }
    } catch (e) { 
    }

    return false;
  };

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dag', [function(){
    
    // 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
    var controller = ['$scope', '$sce', 'Restangular', 'AetherRestangular', 'GaranceRestangular', '$websocket', 
              function($scope ,  $sce ,  Restangular ,  AetherRestangular ,  GaranceRestangular ,  $websocket) {
      
      $scope.dag = {};
      
      $scope.loaded  = false;
      $scope.loading = false;
      
      $scope.download = function() {
        window.location.href = $scope.dagInfo.download;
      }
      
      // 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 
      $scope.loadOnce = function() {
        
        if ($scope.loaded || $scope.loading) {
          return;
        }
        $scope.loading = true;
        
        var dagRestResource = Restangular.one('dags', $scope.dagInfo.name);
        
        if ($scope.dagInfo.name.startsWith('avatar')
            ||
            $scope.dagInfo.name.startsWith('s4hana')
            ||
            $scope.dagInfo.name.startsWith('fiori')) {
          $scope.hideTravis = true;
          $scope.hideSnapshots= true;
          $scope.hideReleases = true;
          $scope.hideGit = false;
          $scope.hideOnOffLine = true;
          $scope.connection = false;
        }

        // 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  
        dagRestResource.get().then(function(dag) {
          
          var nodeArray = [];
          
          if (dag.date) {
            $scope.dagInfo.title = new moment(dag.date).format( "dddd, MMMM Do YYYY, h:mm:ss a");
          } else {
            $scope.dagInfo.title = 'creation date unknown';
          }
          
          dag.nodes.forEach(function(node) {
            if (node.clazz !== "cluster") {
              nodeArray.push(node);
            }
          });
          
          // load topological sort
          var topologicalSortRestResource = Restangular.one('dags', $scope.dagInfo.name).one('topological');
          
          // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
          topologicalSortRestResource.get().then(function(topo) {
            
            // cf. http://stackoverflow.com/questions/13304543/javascript-sort-array-based-on-another-array
            $scope.topological = (function(items, sorted) {
              var result = [];
              sorted.forEach(function(key) {
                var found = false;
                items = items.filter(function(item) {
                  if (!found && item.id == key) {
                    result.push(item);
                    found = true;
                    return false;
                  } else {
                    return true;
                  }
                });
              });
              return result;
            }(nodeArray, topo));

            $scope.loaded = true;
            $scope.loading = false;
          
          }); // topologicalSortRestResource.get().then(function(topo) {
          // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
   
          var nodeMap = {};
          nodeArray.forEach(function(node) {
            nodeMap[node.id] = node;
          });
          $scope.nodeMap = nodeMap;

          var clusterCount = 0;
          var githubHost = $scope.githubHost;
          
          // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
          dag.nodes.forEach(function(node) {
            
            node.building = function() {
              return node.state == "BEING_CLEANED" || node.simulate;
            };
            node.valuenow = 0;
            
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5  
            var Progress = (function($eleme, expected) {
              var startDate = moment();
              var durationmaxexpected = moment.duration(expected);
              var $elementSpan = $eleme.children('span');
              var timer = null;

              window.log('duration max expected:', durationmaxexpected);

              // cf. http://drupalmotion.com/article/debounce-and-throttle-visual-explanation
              var update = _.throttle(function(text) {
                var percentage_complete = (moment() - startDate) / durationmaxexpected * 100;
                var percentage_rounded  = (Math.round(percentage_complete * 100) / 100); 
                if (isFinite(percentage_rounded)) {
                  // window.log('as percentage: ', percentage_rounded);
                  $eleme.css('width', percentage_rounded+"%");
                }                
                if (text) {
                  $elementSpan.text(text);
                }
              }, 666);
              
              var reset = function() {
                startDate           = moment();
                durationmaxexpected = moment.duration(expected);
                $eleme.css('width', "0");
                $elementSpan.text("");
                if (timer) {
                  clearInterval(timer);
                  timer = null;
                }
              };
              
              reset();
              
              timer = setInterval(function () {
                update(); 
                window.log('coucou from timer');
               }, 500);
              
              return {
                startDate : startDate,  
                durationmaxexpected : durationmaxexpected,
                reset : reset,
                update : update
              }
            }); // var Progress = (function($eleme, expected) 
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5  

            var dataStream = null;
            var progress = null;
            
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5  
            node.onCleaningStopped = function() {
              if (!progress) {
                return;
              }
              progress.reset();
              progress = null;
            }
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            node.onCleaningStarted = function(cleaner) {

              if (progress) {
                return;
              }

              function validateCleaner(cleaner) {
                // cf. http://stackoverflow.com/questions/7905929/how-to-test-valid-uuid-guid
                var re = /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
                return re.test(cleaner);
              }
              
              var garanceRes = GaranceRestangular
                .one('series', node.value.gubrid)
                .one('mean');

              // 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 
              garanceRes.get().then( function(garanceJson) {

                var $element = $('table.table > tbody > tr[data-id=' + node.id + '] > td .progress .building'); 

                progress = new Progress($element, garanceJson);
                
                // 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 
                if (validateCleaner(cleaner)) {
                  var url  = $scope.jevaispasmefairechier + 'hub/' + cleaner;
                  
                  // Open a WebSocket connection
                  // window.log("opening cleaner websocket from", url, 'for node', node.name, cleaner);
                  dataStream = $websocket(url);

                  dataStream.onMessage(function(atmosphereMessage) {

                    if (atmosphereMessage.type == "message" && atmosphereMessage.data == 'X') {
                      window.log('received heartbeat');
                      return;
                    }
                    var message = atmosphereMessage.data;
                    
                    var datum = tryParseJSON(message)
                    if (datum) {
                      if (progress) {
                        progress.update(datum.value);
                      }

                      if (datum.key === "result") {
                        if (datum.value === "false") {
                          node.state = "CLEANING_FAILED";
                        } else {
                          node.state = "CLEAN";
                        }
                      }
                      if (datum.key === "close" && datum.value === "close") {
                        dataStream.close(true);
                      }
                    }
                  });

                  dataStream.onClose(function() {
                    window.log(node.id, 'cleaner socket received onClose event', cleaner);
                    if (progress) {
                      progress.reset();
                    }
                    dataStream = null;
                  });

                  dataStream.onError(function() {
                    window.log(node.id, 'cleaner socket received onError event', cleaner);
                    if (progress) {
                      progress.reset();
                    }
                    dataStream = null;
                  });
                } // if (validateCleaner(cleaner)) {
                // 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

              },function(response) {
                window.log('garance ooooooooooops:', response);
              }); // garanceRes.get().then( function(garanceJson) {
              // 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 

            } // end of node.onCleaningStarted function 
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            // cluster ?
            {
              if (node.clazz == "cluster") {
                clusterCount = clusterCount + 1;
                node.value.clusterLabelPos = 'top';
              }
            } // cluster ?
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5
            
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5
            // get GAV
            {
              node.gav = gavpce(node.value && node.value.gubrid ? node.value.gubrid : null);
            }
            
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            // setup short (artifactId) and medium (artifactId+version) and full (groupId+artifactId+version)labels
            {
              
              if (typeof node.value == "undefined" || node.value == null) {
                node.value = {};
              }
              if (typeof node.value.label == "undefined" || node.value.label == null) {
                node.value.label = node.name; 
              }
              node.value.labelShort = node.value.label;

              if (node.gav.ok()) {
                node.value.labelFull   = node.gav.g + ' ' + node.gav.a + ' ' + node.gav.v;
                node.value.labelMedium =                    node.gav.a + ' ' + node.gav.v;
                
              } else {
                node.value.labelFull = node.value.label;
                
                var name    = node.value.labelFull;
                var version = "";
    
                var labelFullSplit = node.value.labelFull.split(' ');
                if (labelFullSplit.length > 1) {
                  name = labelFullSplit.shift();
                  version = labelFullSplit.join(' ');
                }
                  
                var shortName  = name;
                var lastDot = name.lastIndexOf('.');
                if (lastDot != -1) {
                  shortName = name.substr(lastDot+1);
                }
                node.value.labelMedium = shortName + ' ' + version;
              }
            } // setup short and medium and full labels
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
          
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            // setup scm
            {
              node.value.giturl = parseGitUrl({
                  scm    : node.value.scm,
                  commit : node.value.commit,
              });
              githubHost = node.value.giturl.host;
              if (node.value.branch) {
                if (node.value.branch.match(/^[0-9a-f]{40}$/) != null) {
                  node.shortbranch = node.value.giturl.hash;
                } else {
                  node.shortbranch = node.value.branch.replace(/^refs\/heads\//gi, "");
                }
              }
            } // setup scm

            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            // setup gavpce
            {
              if (node.gav.ok()) {
                // prepare for travis
                if (!node.value.scm) {
                  var shortgav  = node.gav.g.replace(/net\.(.*)\.neo/g, "$1");
                  node.reponame = shortgav+"/"+node.gav.a;
                } else {
                  node.reponame = node.value.giturl.slug;
                }
                node.repoid = node.reponame.replace(/\//g, "_");
              } else {
                node.gav = {
                    a : node.value.labelFull
                };
              }
            } // setup gavpce
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            // setup travis 
            if ($scope.connection) {
              // is travis here ?
              var travisURL = "https://api."+$scope.travisHost+"/repos/"+node.reponame+"/branches";
  
              node.travisSvg = $scope.travisUrl + node.reponame + ".svg?branch=" + node.shortbranch + "#" + (new Date().getTime().toString());

              $.ajax({
                url: travisURL,
                crossDomain: true,
                headers: { 'Accept' : 'application/vnd.travis-ci.2+json' }
              })
              .fail(function( data ) {
                node.travis = false;
              })
              .done(function( data ) {
                node.travis = true;
                //
                var foundJob = null; {
                  // search in commits array for the branch
                  var foundCommit = null; {
                    for (var ccc = 0; ccc < data.commits.length; ccc++) {
                      if (data.commits[ccc].branch==node.shortbranch) {
                        foundCommit = data.commits[ccc].id;
                        break;
                      }
                    }
                  }
                  if (foundCommit != null) {
                    // search in branch array for the job
                    for (var bbb = 0; bbb < data.branches.length; bbb++) {
                      if (data.branches[bbb].commit_id==foundCommit) {
                        if (data.branches[bbb].job_ids.length) {
                          foundJob = data.branches[bbb].job_ids[0];
                          break;
                        }
                      }
                    }
                  }
                }
                if (foundJob != null) {
                  node.foundJob = foundJob;
                }
              });
            } // setup travis
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
          
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
            // setup and conditionally exec aether requests
            if (true) {
              node.refreshSnapshot = function() {
                if (!$scope.connection) {
                  return;
                }
                var snapshotRes = AetherRestangular
                  .one('repositories', $scope.snapshotServer.name)
                  .one('groups',       node.gav.g )
                  .one('artifacts',    node.gav.a )
                  .one('versions',     '[,)' )
                  .one('extensions',   'pom' );
                
                node.resolvingSnapshot = "progressBackground";
                snapshotRes.get().then(function(aetherJson) {
                  node.resolvingSnapshot = "";
                  node.resolvedSnapshot = $sce.trustAsHtml(aetherJson.version);
                  setTimeout(function() {
                    // @todo: refresh svg
                    // window.log('@todo: refresh svg');
                  }, 2000);
                  
                },function(response) {
                  node.resolvingSnapshot = "";
                  // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
                  node.resolvedSnapshot = $sce.trustAsHtml("&#8709;");
                  setTimeout(function() {
                    // @todo: refresh svg
                    // window.log('@todo: refresh svg');
                  }, 2000);
                });
              }
              
              node.refreshRelease = function() {
                if (!$scope.connection) {
                  return;
                }
                var releaseRes = AetherRestangular
                  .one('repositories', $scope.releaseServer.name)
                  .one('groups',       node.gav.g )
                  .one('artifacts',    node.gav.a )
                  .one('versions',     '[,)' )
                  .one('extensions',   'pom' );
                
                node.resolvingRelease = "progressBackground";
                releaseRes.get().then(function(aetherJson) {
                  node.resolvingRelease = "";
                  node.resolvedRelease = $sce.trustAsHtml(aetherJson.version);
                },function(response) {
                  node.resolvingRelease = "";
                  // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
                  node.resolvedRelease = $sce.trustAsHtml("&#8709;");
                });
              }
              
              node.refreshSnapshot();
              node.refreshRelease();
            } // setup and conditionally exec aether requests
            // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

          }); // dag.nodes.forEach
          $scope.githubHost = githubHost;


          // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
          if (clusterCount > 1 ) {
            // cf. http://tools.medialab.sciences-po.fr/iwanthue/
            var colors = ["#3CF7BD",
                          "#D118AB",
                          "#6E3904",
                          "#A6BCE6",
                          "#C2E12C",
                          "#0A5BC6",
                          "#E493AB",
                          "#D6F3B7",
                          "#316B7B",
                          "#289870",
                          "#53327D",
                          "#9C1D1D"];
            var color = 0;
            dag.nodes.forEach(function(node) {
              if (node.clazz == "cluster") {
                node.value.style = "fill: " + colors[(color++)%colors.length];
              }
            });
          } // if (clusterCount > 1 ) {
        
          // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
          dag.links.forEach(function(edge) {
            if (edge.clazz == "parent") {
              edge.value.style = "stroke: #7777FF; stroke-width: 1px; stroke-dasharray: 5, 5;";
            } else if (edge.clazz == "transitive") {
              edge.value.style = "stroke: #acd6d6; stroke-width: 1px; stroke-dasharray: 2, 3;";
            }
            edge.value.lineInterpolate = 'basis';
            edge.value.arrowhead = 'normal';
            edge.value.arrowheadStyle  = "fill: #000";
          }); // dag.links.forEach(function(edge) {
        
          // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
          $scope.askTravis2rebuild = function(node) {
            console.log("no askTravis2rebuild");
            return;
          };
          if (true) {
            $scope.askTravis2rebuild = function(node) {
              if (!node.foundJob) {
                return;
              }
    
              $.ajax({
                url: $scope.travisUrl+'api/jobs/'+node.foundJob+'/restart',
                method: "POST",
                crossDomain: true,
                headers: {'Accept' : 'application/vnd.travis-ci.2+json'}
              })
              .fail(function( jqXHR, textStatus, errorThrown ) {
                alert("[]\nthere was some issue connecting with travis, rebuild has not been triggered.\ntextStatus: "+textStatus+"\nerrorThrown: "+errorThrown);
              })
              .done(function( data, textStatus, jqXHR ) {
                var buildStartedRes = Restangular
                  .one('dags',  $scope.dagInfo.name)
                  .one('nodes', node.name )
                  .one('event', 'BUILD_STARTED' );
                
                buildStartedRes.patch({}, undefined, { 'Content-Type': 'text/plain' }).then(
                  function(json)    {
                    window.log('message BUILD_STARTED send to api/dagr for node ' + node.name );
                  },
                  function(response) {
                    window.log('error sending BUILD_STARTED to api/dagr for node ' + node.name );
                  }
                );
              });
            } // $scope.askTravis2rebuild = function(node) { 
          }
          // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 

          $scope.dag = dag;
          
          $scope.cleanNode = function(node) {
            var snapshotRes = Restangular
              .one('dags',  $scope.dagInfo.name)
              .one('nodes', node.name )
              .one('event', 'BUILD_OK' );
            
            snapshotRes.patch({}, undefined, { 'Content-Type': 'text/plain' }).then(
              function(json)    {},
              function(resonse) {}
            );
          };
          
          $scope.cleanAllNodes = function() {
            $scope.topological.forEach(function(node){
              $scope.cleanNode(node);
            })
          }
          
          $scope.toggleSimulate = function() {
            if ($scope.topological.length > 0 ) {
              $scope.topological[0].simulate = ! $scope.topological[0].simulate;
            }
          };
          
        }); // dagRestResource.get().then
        // 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  

      } // $scope.loadOnce = function() {
      // 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 

      $scope.loadOnce();

    }]; // controller definition
    // 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
    
    return {
      restrict    : 'E',
      controller  : controller,
      link        : function ($scope, $element, attr) {
        $scope.$watch(attr.ngShow, function() {
          var visible = eval('$scope.' + attr.ngShow);
          if (visible) {
            $scope.loadOnce();
          }
        });
      }
    };
    
  }]); // angular.module('dagsApplication').directive('dag', [function(){
  
  /////////////////////////////////////////////////////////////////////////////
  function gavpce(str) {
    var _this_ = {};

    function isok(x) {
        if (typeof x === "undefined" || x === null || x.length === 0) {
            return false;
        }
        return true;
    }

    /*
    g    Group id of the artifact (Required)
    a    Artifact id of the artifact (Required)
    t    Type of the artifact (Required)
    v    Version of the artifact (Required) Supports resolving of "LATEST", "RELEASE" and snapshot versions ("1.0-SNAPSHOT") too
    p    Packaging type of the artifact (Optional)
    c    Classifier of the artifact (Optional)
    e    Extension of the artifact (Optional)
    
    [r    Repository that the artifact is contained in (Required)] <-- not needed
    
    str = "g:a:t:v:p:c:e";
    
    */
    // verify that parameter is fine
    // if not, return an object that containing only a 'ok' function returning false.
    if (!isok(str)) {
        _this_.ok = function() {return false;}
        return _this_;
    }

    var arr = str.split(":");

    _this_.g = arr[0];
    _this_.a = arr[1];
    _this_.t = arr[2];
    _this_.v = arr[3];
    _this_.p = arr[4];
    _this_.c = arr[5];
    _this_.e = arr[6];

    // if no package , package is type
    if (!isok(_this_.p)) {
        _this_.p = _this_.t;
    }

    _this_.ok = function() {
       var mandatories = [_this_.g, _this_.a, _this_.t, _this_.v];
       for (j = 0; j < mandatories.length; j++) {
           if (!isok(mandatories[j])) {
               return false;
           }
       }
       return true;
    }

    return _this_;
    
  } // function gavpce(str)
  
})();
