<%@ page contentType="text/html" pageEncoding="UTF-8" trimDirectiveWhitespaces="true" 
%><%@ page import="net.aequologica.neo.geppaequo.webjars.WebJar"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout" %>
<%  net.aequologica.neo.geppaequo.servlet.ZeroUtils.HostContextUserAccountAndApp(request);
%><%
  Boolean isWizard = request.isUserInRole("wizard") || request.isUserInRole("BUILTIN\\Administrators");
  request.setAttribute("isGeppaequoWizard", isWizard);
%><%-- module="dagr" --%><t:layout  jsmodules="angular modernizr datatables moment">
<base href="<c:url value='/modules/dagr/index.jsp' />">
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/dags.css'        />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/graph.css'       />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/topo.css'        />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/building.css'    />"></link>

<style>
.progressBackground {
    background: url("<c:url value='/modules/dagr/images/animated.gif'  />")
}

h3 .btn, form#shorten .btn {
    padding: .1rem .5rem;
}
</style>
 
<div id="container" ng-app="dagsApplication">

  <section ng-controller="tabsController">


    <dag>
        
        <div>
          <form id    = "shorten" 
                class = "toolbar toprightfloating"> 
            <span id          = "tip"
                  style       = "display:none; color: black; font-size:smaller;"
                  class       = "alert alert-info">
            </span>
            <span id          = "shortenLegend" 
                  data-tip    = ""
                  type        = "button" 
                  class       = "btn btn-secondary btn-sm btn-secondary"
                  ng-click    = "bumpShortenIndex()">
              <i class="fa {{shorten_icons[shorten_index]}}" ></i>
            </span>
            <span ng-hide     = "{{hideOnOffLine}}"
                  id          = "online" 
                  data-tip    = "online / offline"
                  type        = "button" 
                  class       = "connection {{connection ? 'on' : 'off'}} btn btn-secondary btn-sm btn-secondary"
                  ng-click    = "toggleConnection()">
              <i class="fa fa-bolt" ></i>
            </span>
            
            <a    id          = "daglist"
                  data-tip    = "dag list"
                  href        = "<c:url value='/modules/dagr/dags-list.jsp'/>"
                  type        = "button" 
                  class       = "btn btn-secondary btn-sm btn-secondary">
              <i class="fa fa-list" /></i>
            </a>
            
            <span id          = "download" 
                  data-tip    = "download <i>{{dagInfo.name}}</i> dag"
                  type        = "button" 
                  class       = "btn btn-secondary btn-sm btn-secondary"
                  data-id     = "{{dagInfo.name}}" 
                  ng-click    = "download()">
              <i class="fa fa-download"></i>
            </span>
            <a    id          = "howto"
                  data-tip    = "how-to"
                  href        = "<c:url value='/lifebuoy/dagr-how-to.jsp'/>"
                  type        = "button" 
                  class       = "btn btn-secondary btn-sm btn-secondary">
              <i class="fa fa-question-circle" /></i>
            </a> 
            <span id          = "idspy" 
                  type        = "button" 
                  data-tip    = "dag id">
            </span>
          </form>
        </div>
    
        <h3 style="margin:0;">
          <span>{{dagInfo.name}}</span>
          <div class="btn-group" style="font-size:16px;">
            <button type="button" class="btn btn-sm btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            </button>
            <div class="dropdown-menu">
            </div>
          </div>            
        </h3>
             
        
        
        <dag-svg id="1" resize></dag-svg>
        
        <dag-topological></dag-topological>
        
        <dag-websocket></dag-websocket>

    </dag>
  
  </section>

</div>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("d3.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dagre-d3.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/angular-websocket.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/restangular.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("ui-bootstrap-tpls.min.js")%>' />"></script>

<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/giturl.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dagre-d3-helper.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dags.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-websocket.js' />"></script>

<script type="text/javascript">

<%-- cf. https://github.com/cpettitt/dagre-d3/issues/202 --%>
SVGElement.prototype.getTransformToElement = SVGElement.prototype.getTransformToElement || function(elem) {
  return elem.getScreenCTM().inverse().multiply(this.getScreenCTM());
};

var getShortenLegend;

;(function(){
  angular.module('dagsApplication').controller('tabsController', 
      [        '$scope', 'localStorageService', 'loadAllDagsService', 
       function($scope ,  localStorageService ,  loadAllDagsService) {
        
    loadAllDagsService.doWork();
    
    var dagInfos = [<c:forEach items="${model}" var="_this_" varStatus="status">
      {
        id         : '${status.count}',
        name       : '${_this_.name}',
        key        : '${_this_.key}',
        source     : '${_this_.url}',
        download   : '<c:url value="/api/geppaequo/stnemucod/v1/document/dags/"/>${_this_.name}',
        clazz      : undefined,
      },</c:forEach>
    ];
    
    dagInfos.sort(function(a, b) {
      // cf. http://stackoverflow.com/questions/51165/how-do-you-do-string-comparison-in-javascript
      return a.name.localeCompare(b.name);
    });
    
    var snapshotServer = {
        name        : "${applicationScope.quintessence.snapshotRepo.name}",
        baseURL     : "${applicationScope.quintessence.snapshotRepo.uri}"
    };
    var releaseServer = {
        name        : "${applicationScope.quintessence.releaseRepo.name}",
        baseURL     : "${applicationScope.quintessence.releaseRepo.uri}"
    };
    
    $scope.dagInfos       = dagInfos;
    var curdag = localStorageService.get("dag");
    $scope.dagInfo = _.find($scope.dagInfos, function(dagInfo) { return dagInfo.key == curdag; });
    if (!$scope.dagInfo && $scope.dagInfos.length > 0) {
      $scope.dagInfo = $scope.dagInfos[0];
    }
    $scope.snapshotServer = snapshotServer;
    $scope.releaseServer  = releaseServer;
    
    $scope.travisHost = "${applicationScope.dagr.travisHost}";
    $scope.travisUrl = "https://"+$scope.travisHost+"/";
    $scope.githubHost = "${applicationScope.dagr.githubHost}";
    $scope.githubUrl = "https://"+$scope.githubHost+"/";
    
    $scope.connection = localStorageService.get('connection');
    $scope.toggleConnection = function() {
      $scope.connection = !$scope.connection;
      localStorageService.set('connection', $scope.connection);
      location.reload(); 
    };
    
    $scope.shorten_icons = [ "fa-minus",
                             "fa-plus",
                             "fa-asterisk" ];
    $scope.shorten_legend = ["( <b>short -</b> | medium + | full * ) label",
                             "( short - | <b>medium +</b> | full * ) label",
                             "( short - | medium + | <b>full *</b> ) label" ];
    
    var shorten_index = localStorageService.get('shorten_index');
    if (typeof shorten_index === "undefined" || shorten_index == null) {
      shorten_index = 0;
    }
    $scope.shorten_index = shorten_index % $scope.shorten_icons.length;
    $scope.getShortenLegend = getShortenLegend = function() {
      return  $scope.shorten_legend[ $scope.shorten_index];
    }
    $scope.bumpShortenIndex = function() {
      $scope.shorten_index = ($scope.shorten_index + 1) % $scope.shorten_icons.length;
      localStorageService.set('shorten_index', $scope.shorten_index);
    }
    
    $scope.gimmethestuff = "<%= net.aequologica.neo.dagr.model.Dag.Node.State.gimmethestuff()%>";
    
    $scope.jevaispasmefairechier = 'ws'
      <c:if test="${pageContext.request.secure}">
    + 's'
    </c:if>
    + '://'
    + '${pageContext.request.serverName}'
    + ':'
    + '${pageContext.request.serverPort}'
    + Geppaequo.contextPath;
    
    $scope.tabSelected = function(dagInfo) {
      dagInfo.active = true;
      // window.log('activated', dagInfo.name);
    };
    $scope.tabDeselected = function(dagInfo) {
      dagInfo.active = false;
      // window.log('desactivated', dagInfo.name);
    };

    $scope.magicien = false;
    <c:if test='${isGeppaequoWizard}'>
    $scope.magicien = true;
    </c:if>
    
      
  }]);
  
  // http://stackoverflow.com/a/16730809/1070215
  angular.module('dagsApplication').factory("loadAllDagsService",['$q',function($q){

    var worker = new Worker('<c:url value="/modules/dagr/scripts/"/>'+'load-all-dags.js');
    var defer = $q.defer();
    worker.addEventListener('message', function(e) {
      console.log('Worker said: ', e.data);
      var $dm = $('h3 .dropdown-menu');
      $dm.empty();
      e.data.sort(function(a, b) {
        // cf. http://stackoverflow.com/questions/51165/how-do-you-do-string-comparison-in-javascript
        return a.name.localeCompare(b.name);
      });
      
      _.forEach(e.data, function(dag) {
        $dm.append($('<a class="dropdown-item">').attr({href:"<c:url value='/api/dagr/v1/dags/'/>"+dag.name}).text(dag.name));
      });
      defer.resolve(e.data);
    }, false);

    return {
        doWork : function(){
            defer = $q.defer();
            worker.postMessage({
              url : "<c:url value='/api/dagr/v1/dags' />"
            }); // Send data to our worker. 
            return defer.promise;
        }
    };
  }]);
  
})();

</script>

<script type="text/javascript">
  $(document).ready(function(){
    
    // tooltips
    $('form#shorten [id="shortenLegend"]').on( 'click', function() {
      $('form#shorten span#tip').html(getShortenLegend());
    });
    $('form#shorten [type="button"]').hover(
        function() {
          if ($(this).attr('id') == "shortenLegend") {
            $('form#shorten span#tip').html(getShortenLegend()).show();
          } else {
            $('form#shorten span#tip').html($(this).data("tip")).show();
          }
        }, function() {
          $('form#shorten span#tip').empty().hide();
        }
    );
    
    $('#toggleSocketIFrame').on('click', function(event){
      event.preventDefault();
      $('#dagsocket').toggle();
    })
  });

</script>
