<%@   page contentType="text/html" pageEncoding="UTF-8"
%><%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"
%><%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"
%><%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"
%><%-- module="dagr" --%><t:layout  jsmodules="angular moment handlebars">

<script id="handlebars_messages" type="text/x-handlebars-template"><ul style=" list-style-type: none; padding:0;">
  {{#each this}}{{#each this}}<li>
    <strong>{{@key}}</strong> {{this}}
  </li>{{/each}}{{/each}}</ul></script>

  <style>
    ul {
      list-style-type: none;
    }
    span#back_to_index {
      white-space: nowrap; 
      overflow:hidden;
    }
  </style>
  
  <c:if test="${empty pageContext.request.remoteUser}">
  <div id="please_log_in" class="alert alert-info" >
    <span class="label label-info">info</span>
    <span><a href="<c:url value='/modules/login.jsp'/>"><span><i class="fa fa-sign-in"></i>&nbsp;Sign in</span></a> to get the list of DAGs</span>
  </div>
  </c:if>

  <div ng-app="ngAppDAGs" class="row">
    <h2 class="col-lg-12">all DAGs</h2>
    
    <form ng-controller="DAGsCtrl">
      <ul class="unstyled col-lg-8">
        <li ng-repeat="dag in dags| orderBy:'name'" style="border-bottom: 1px dashed #999;">
          <input type="radio" ng-model="$parent.curdag" name="name" value="{{dag.name}}" ng-change="change()"//>
          <a href="<c:url value='/api/dagr/v1/dags/'/>{{dag.key}}">
            {{dag.name}}
          </a>
        </li>
      </ul>
    </form>
  </div>

  <div>
    <span id="back_to_index" class="alert alert-info" style="display: inline-block;">
      <span class="label label-info">info</span>
      <span>click the <a href="<c:url value='/api/dagr/v1/dags/'/>">dagr</a> menu item to display the selected dag</span>
    </span>
  </div>

  <div class="btn-group btn-group-md" role="group" aria-label="...">
    <button id="reload" type="button" class="btn btn-secondary">
      <span>reload DAGs <img id="ajaxLoading" src="<c:url value='/assets/images/animated_orange_refresh_22.png'/>" style="height:18px; width:auto;"> </span>
    </button>
    <a type="button" class="btn btn-secondary" href='<c:url value="/api/geppaequo/stnemucod/v1/html/dags"/>' target = "_dags">DAGs directory <i class="fa fa-external-link" aria-hidden="true"></i></a>
  </div>
  <div id="messages" style="padding: 1em 0 0 0;"></div>
  <div  id="alert" class="alert alert-dismissable" style="display:none; ">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  </div>

</t:layout>

<script type="text/javascript" src='<c:url value="/modules/dagr/scripts/reload-dags.js"/>' ></script>

<script type="text/javascript">

angular.module('ngAppDAGs', ['angular-loading-bar', 'LocalStorageModule'])
.config(function(cfpLoadingBarProvider) {
  cfpLoadingBarProvider.includeSpinner = true;
}).config(function (localStorageServiceProvider) {
  localStorageServiceProvider
    .setPrefix('dagr');
}).controller( 'DAGsCtrl',

  function($scope, $http, localStorageService) {
    $scope.dags   = [];
    $scope.curdag = undefined;
    
    var load = function(){
      $http({
          method: 'GET',
          url: "<c:url value='/api/dagr/v1/dags' />",
        }).success(function(data, status, headers, config) {
          $scope.dags = data;
          $scope.curdag = localStorageService.get("dag");
          console.log("curdag", $scope.curdag);
        }).error(function(data, status, headers, config) {
          $scope.dags = [];
          $scope.curdag = undefined;
      });
    }
    
    load();

    dagrReload('<c:url value="/"/>', function() {
      load();
    });

    $scope.change = function() {
      localStorageService.set("dag", this.dag.key);
    };
  }
);

</script>
