/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import java.io.IOException;
import javax.inject.Inject;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.jaxrs.AbstractResource;
import net.aequologica.neo.dagr.model.Dag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/github")
public class ResourceGithub
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(ResourceGithub.class);
    @Inject
    private Bus<Dag.Node> bus;

    @POST
    @Path(value="/notification")
    @Consumes(value={"application/json"})
    public Response getPushNotification(String payload) throws IOException {
        try {
            log.debug("[github] payload: {}", (Object)payload);
            System.out.println("[github] payload: " + payload.replace("\n", "").replace("\r", ""));
            JsonObject githubPushPayload = (JsonObject)this.mapper.readValue(payload, JsonObject.class);
            String repo_fullname = null;
            String ref = githubPushPayload.getString("ref");
            JsonObject repositoryObject = githubPushPayload.getJsonObject("repository");
            if (repositoryObject != null) {
                repo_fullname = repositoryObject.getString("full_name");
            }
            if (repo_fullname != null && ref != null) {
                log.debug("[bus] sending event {}, repo_fullname='{}', ref='{}' to the bus", new Object[]{BusEvent.Type.PUSH, repo_fullname, ref});
                System.out.println("[bus] sending event " + BusEvent.Type.PUSH + ", repo_fullname='" + repo_fullname + "', ref='" + ref + "' to the bus");
                this.bus.send(BusEvent.Type.PUSH, repo_fullname, ref);
            }
            return Response.noContent().build();
        }
        catch (Exception e) {
            log.error("[github] exception {} logged and re-thrown", (Object)e.getMessage());
            System.err.println("[github] exception " + e.getMessage() + "logged and re-thrown");
            throw e;
        }
    }
}

