/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.garance;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.garance.SeriesSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;

@Singleton
@WebListener
public class Listener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    @Inject
    private SeriesSet seriesMap;
    @Inject
    private Bus<Dag.Node> bus;
    private Map<String, Date> startMap = new HashMap<String, Date>();
    private Subscription subscription;

    public void contextInitialized(ServletContextEvent arg0) {
        this.subscription = this.bus.toObservable().filter(event -> event.getType().equals((Object)BusEvent.Type.BUILD_STARTED) || event.getType().equals((Object)BusEvent.Type.BUILD_OK) || event.getType().equals((Object)BusEvent.Type.BUILD_ERROR)).map(event -> event.get()).subscribe(node -> this.sendNotification((Dag.Node)node));
        log.debug("[garance] subscribed !");
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
            this.subscription = null;
            log.debug("[garance] unsubscribed !");
        }
    }

    void sendNotification(Dag.Node node) {
        if (node.getState().equals((Object)Dag.Node.State.BEING_CLEANED)) {
            this.startMap.put(node.getValue().getGubrid(), new Date());
        } else if (node.getState().equals((Object)Dag.Node.State.CLEAN)) {
            Date start = this.startMap.get(node.getValue().getGubrid());
            if (start != null) {
                this.seriesMap.put(node.getValue().getGubrid(), (double)(new Date().getTime() - start.getTime()));
                this.seriesMap.save();
            }
            this.startMap.remove(node.getValue().getGubrid());
        } else {
            node.getState().equals((Object)Dag.Node.State.CLEANING_FAILED);
        }
    }
}

